#
#  $Id: product.py,v 1.1 1999/12/11 12:35:11 rob Exp $
#
#  Copyright 1999 Rob Tillotson <robt@debian.org>
#  All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee or royalty is
#  hereby granted, provided that the above copyright notice appear in
#  all copies and that both the copyright notice and this permission
#  notice appear in supporting documentation or portions thereof,
#  including modifications, that you you make.
#
#  THE AUTHOR ROB TILLOTSON DISCLAIMS ALL WARRANTIES WITH REGARD TO
#  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
#  AND FITNESS.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
#  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
#  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
#  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE!
#
"""
"""

__version__ = '$Id: product.py,v 1.1 1999/12/11 12:35:11 rob Exp $'

__copyright__ = 'Copyright 1999 Rob Tillotson <robt@debian.org>'

import sys, os, string

import Pyrite
from Pyrite import _
from Pyrite.Application import Application
from Sulfur.Options import Boolean, String, Integer, O_NOCONFIG, O_NONINTERACTIVE, O_MULTIPLE
from Sulfur.misc import import_module

class App(Application):
    name = 'Pyrite Product Manager'
    version = Pyrite.version
    author = Pyrite.author
    description = _("Manage products.")

    options = [
	String('package', '', _("product package"), None,
	       (O_NONINTERACTIVE, O_NOCONFIG), ['package', 'p']),
	
	String('install', '', _("install a product package"), None,
	       (O_NONINTERACTIVE, O_NOCONFIG), ['install', 'i']),
	String('remove', '', _("remove a product"), None,
	       (O_NONINTERACTIVE, O_NOCONFIG), ['remove', 'r']),
	String('query', '', _("query a product"), None,
	       (O_NONINTERACTIVE, O_NOCONFIG), ['query', 'q']),
	Boolean('list', 0, _("list products"), None,
	       (O_NONINTERACTIVE, O_NOCONFIG), ['list', 'l']),
	]

    def __init__(self):
	Application.__init__(self)

	self.config_path = 'Pyrite::ProductManager'


    def run(self, argv):
	if self.get_option('install'):
	    package = self.get_option('install')
	    print _("Attempting to install product in package '%s'...") % package
	    try:
		n = self.product_install(package)
		print _("Installed %s from package '%s'.") % (n, package)
	    except:
		print _("Could not install package '%s' as a product.") % package

	elif self.get_option('remove'):
	    name = self.get_option('remove')
	    if not self.product_installed(name):
		print _("Product '%s' is not installed.") % name
	    else:
		print _("Removing %s...") % name
		self.product_remove(name)

	elif self.get_option('query'):
	    name = self.get_option('query')
	    if self.product_installed(name):
		i = self.product_info(name)
		print _("Product Name : %s") % i['name']
		print _("Package      : %s") % i['package']
		print _("Version      : %s") % i['version']
		print _("Author       : %s") % i['author']
		print _("Description  : %s") % i['description']
	    else:
		print _("Product '%s' is not installed.") % name

	elif self.get_option('list'):
	    l = self.product_list()
	    if not l:
		print _("No Pyrite products are installed.")
	    else:
		print "%-15s %-10s %-50s" % (_("Name"), _("Version"), _("Description"))
		print
		for p in l:
		    print "%-15s %-10s %-50s" % \
			  (p['name'][:15], p['version'][:10],
			   string.split(p['description'],'\n')[0][:50])

	else:
	    print _("You must specify one of --install, --remove, --query, or --list.")
	    
