#
#  $Id: Filter.py,v 1.7 1999/12/11 12:35:11 rob Exp $
#
#  Copyright 1998-1999 Rob Tillotson <robt@debian.org>
#  All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee or royalty is
#  hereby granted, provided that the above copyright notice appear in
#  all copies and that both the copyright notice and this permission
#  notice appear in supporting documentation or portions thereof,
#  including modifications, that you you make.
#
#  THE AUTHOR ROB TILLOTSON DISCLAIMS ALL WARRANTIES WITH REGARD TO
#  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
#  AND FITNESS.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
#  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
#  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
#  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE!
#
"""Import/Export Filters.
"""

__version__ = '$Id: Filter.py,v 1.7 1999/12/11 12:35:11 rob Exp $'

__copyright__ = 'Copyright 1998-1999 Rob Tillotson <robt@debian.org>'


import sys
from Pyrite import Plugin, _

# 12/11/99:
# We are interested in doing several different types of operations:
#
# - translate a single record between palm and desktop formats
# - translate a series of records and merge with an existing database
# - translate a seried of records and replace an existing database
# - translate arbitrary outside data to records and merge or replace
# - translate records (whole file or partial) to arbitrary outside
#   format and do something with it
#
# from this, there appear to be several basic operations:
#
# - given a record, call an arbitrary function to do something with
#   it.
# - given a series of records, call the above function multiple times.
# - given a whole database, do the above but have additional
#   callbacks for start/end, appblock, etc.
#
# - the same goes for input, except the callbacks should return
#   records etc.; the loop can stop when it gets an exception.
#
# so, each filter should have properties as follows:
#
#  - import-recs   - can import and export individual records
#    export-recs
#  - import        - can import and export entire DBs
#    export
#
# and others to be defined later, for translation and filter chains.
#

# old:
#
# Filters operate on record objects.  Each filter can be a SOURCE, a
# TARGET, or a TRANSFORM; the basic difference between these is simply
# one of semantics.  A source only produces record objects, a target
# only accepts them, and a transform both accepts and produces them.
#
# The most basic filter operation is __call__, which accepts and
# returns a list of records (depending on what role the filter
# plays, of course).  A complete filter run is basically a loop which
# calls one filter after another, passing records along the chain until
# something raises an exception.
#
#
# Properties:
#
#    source - this filter is a source, i.e. doesn't accept records
#    target - this filter is a target, i.e. doesn't supply records
#    filter - this filter can filter records
#
# If there is more than one of these properties, the filter can be
# used in any one of the specified roles.
#
#
# Like stores, filter plug-ins are actually factories for an internal
# base-filter object.  This is so that they can have temporary state,
# even though the plug-in might be instantiated only once.
#

class BaseFilter:
    def __init__(self, plugin, role):
	self.plugin = plugin
	self.role = role
    
    def __call__(self, records):
	return records
    
class Filter(Plugin.Plugin):
    """
    Superclass for all filters.
    """
    type = 'Filter'
    filter_class = BaseFilter

    def __call__(self, role, *a, **kw):
	if not self.has_property(role):
	    raise RuntimeError, _("filter '%s' does not support use as %s") % \
		  (self.__class__.__name__, role)
	return apply(self.filter_class, (self, role)+a, kw)
    
