#
#  $Id: ArchiveFile.py,v 1.2 1999/12/11 12:35:11 rob Exp $
#
#  Copyright 1999 Rob Tillotson <robt@debian.org>
#  All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee or royalty is
#  hereby granted, provided that the above copyright notice appear in
#  all copies and that both the copyright notice and this permission
#  notice appear in supporting documentation or portions thereof,
#  including modifications, that you you make.
#
#  THE AUTHOR ROB TILLOTSON DISCLAIMS ALL WARRANTIES WITH REGARD TO
#  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
#  AND FITNESS.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
#  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
#  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
#  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE!
#
"""
"""

__version__ = '$Id: ArchiveFile.py,v 1.2 1999/12/11 12:35:11 rob Exp $'

__copyright__ = 'Copyright 1999 Rob Tillotson <robt@debian.org>'

import os, tempfile, shutil

import Pyrite
import Pyrite.Store
from Sulfur.Options import String

from Pyrite.prc import File

from Pyrite import _

class ArchiveFileStore(Pyrite.Store.BaseStore):
    properties = ('read','list')
    db_properties = ('id-unique', 'id-replace')

    def __init__(self, path='', format=None):
	Pyrite.Store.BaseStore.__init__(self)

	if not format:
	    p = string.lower(path)
	    if p[-4:] == '.zip': format = 'zip'
	    elif p[-4:] == '.tar': format = 'tar'
	    elif p[-7:] == '.tar.gz' : format = 'targz'
	    elif p[-8:] == '.tar.bz2' : format = 'tarbz2'

	if not format or not self.has_option('unpack-%s-command' % format):
	    raise RuntimeError, _("archive '%s' format unknown or unspecified") % path

	u = self.get_option('unpack-%s-command' % format)

	td = tempfile.mktemp()
	os.mkdir(td)

	os.system(u % {'dir': td, 'file': path})

	self.path = td

    

class Store(Pyrite.Store.Store):
    name = 'ArchiveFile'
    author = Pyrite.author
    version = Pyrite.version
    description = _("PRC/PDB files in an archive file (tar, zip, etc.)")
    properties = ['read','list']

    options = [
	String('unpack-zip-command', 'unzip -d %(dir)s %(file)s',
	       _("Command to unpack zip archives")),
	String('unpack-tar-command', 'tar -x -C %(dir)s -f %(file)s',
	       _("Command to unpack tar archives")),
	String('unpack-targz-command', 'tar -x -z -C %(dir)s -f %(file)s',
	       _("Command to unpack gzipped tar archives")),
	String('unpack-tarbz2-command', 'tar -x -I -C %(dir)s -f %(file)s',
	       _("Command to unpack bzipped tar archives")),
	]
    
    store_class = ArchiveFileStore
