/*
 * rules.c - Routine which try to enforce the rules of freecell.
 */

#include <stdlib.h>

#include "fc.h"
#include "err.h"

#include "card.h"

/* ---------------------------------------------------------------------- */
int
r_cardonstack(struct card *from, struct card *to)
{
     if (to == NULL) return(TRUE);
     if (from == NULL) return(FALSE);
     
     if (card_color(from) == card_color(to)) return(FALSE); 
	 
     if (card_getpips(to) - 1 != card_getpips(from)) return(FALSE);
     return(TRUE);
}

/* ---------------------------------------------------------------------- */
int
r_cardonpile(struct card *from, struct card *to)
{
     if (to == NULL) return(card_getpips(from) == ace);
     if (from == NULL) return(FALSE);
     
     if (card_getsuit(from) != card_getsuit(to)) return(FALSE);
     if (card_getpips(to) != card_getpips(from) - 1) return(FALSE);
     return(TRUE);
}
