#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <asm/arch/hardware.h>
#include <asm/arch/pxa-regs.h>

static int __init geofft_start(void) {

	int i;
	for (i=0; i<121; i++)
		printk("GPLR[%d] = %d; GPDR[%d] = %c; GAFR[%d] = %d\n",
				i,
				(GPLR(i) & GPIO_bit(i))?1:0,
				i,
				(GPDR(i) & GPIO_bit(i))?'O':'I',
				i,
				(GAFR(i) & (3 << ((i & 0xf) * 2))) >> ((i & 0xf) * 2));
	return 0;
}

static void __exit geofft_end(void) {
}

module_init(geofft_start);
module_exit(geofft_end);
MODULE_LICENSE("GPL");
