#ifndef _IRQS_H2200_H_
#define _IRQS_H2200_H_

/**
 * H2200 interrupt definitions  
 *
 * - Initial version based on h5400-ints.h by Joris Gorinsek - beton@ulyssis.org
 */

#if defined(CONFIG_ARCH_H2200)

#define H2200_HAMCOP_IRQ_COUNT 26
#define H2200_HAMCOP_IRQ_START IRQ_BOARD_START

#define IRQ_H2200_ASIC_BUTTON_RST       (H2200_HAMCOP_IRQ_START + 0)
#define IRQ_H2200_ASIC_BUTTON_1		(H2200_HAMCOP_IRQ_START + 1)
#define IRQ_H2200_ASIC_BUTTON_2		(H2200_HAMCOP_IRQ_START + 2)
#define IRQ_H2200_ASIC_BUTTON_3		(H2200_HAMCOP_IRQ_START + 3)
#define IRQ_H2200_ASIC_BUTTON_4		(H2200_HAMCOP_IRQ_START + 4)
#define IRQ_H2200_GPA5			(H2200_HAMCOP_IRQ_START + 5)
#define IRQ_H2200_GPA6			(H2200_HAMCOP_IRQ_START + 6)
#define IRQ_H2200_BATT_FLT		(H2200_HAMCOP_IRQ_START + 7)
#define IRQ_H2200_GPB0			(H2200_HAMCOP_IRQ_START + 8)
#define IRQ_H2200_GPB1			(H2200_HAMCOP_IRQ_START + 9)
#define IRQ_H2200_GPB2			(H2200_HAMCOP_IRQ_START + 10)
#define IRQ_H2200_GPB3			(H2200_HAMCOP_IRQ_START + 11)
#define IRQ_H2200_GPB4			(H2200_HAMCOP_IRQ_START + 12)
#define IRQ_H2200_GPB5			(H2200_HAMCOP_IRQ_START + 13)
#define IRQ_H2200_GPB6			(H2200_HAMCOP_IRQ_START + 14)
#define IRQ_H2200_EAR_IN		(H2200_HAMCOP_IRQ_START + 15)
#define IRQ_H2200_DMA0			(H2200_HAMCOP_IRQ_START + 16)
#define IRQ_H2200_TICK			(H2200_HAMCOP_IRQ_START + 17)
#define IRQ_H2200_ALARM			(H2200_HAMCOP_IRQ_START + 18)
#define IRQ_H2200_ONEWIRE		(H2200_HAMCOP_IRQ_START + 19)
#define IRQ_H2200_SDHC			(H2200_HAMCOP_IRQ_START + 20)
#define IRQ_H2200_ADCTS			(H2200_HAMCOP_IRQ_START + 21)
#define IRQ_H2200_ADC			(H2200_HAMCOP_IRQ_START + 22)
#define IRQ_H2200_WDT			(H2200_HAMCOP_IRQ_START + 23)
#define IRQ_H2200_KEYPAD		(H2200_HAMCOP_IRQ_START + 24)
#define IRQ_H2200_NFIF	                (H2200_HAMCOP_IRQ_START + 25)

#define H2200_MAX_IRQ (H2200_HAMCOP_IRQ_START + H2200_HAMCOP_IRQ_COUNT)

#if H2200_MAX_IRQ > NR_IRQS
#error need to increase number of board IRQs
#endif

#endif /* CONFIG_ARCH_H2200 */

#endif /* _IRQS_H2200_H_ */
