/** @file if_cf.h
  * @brief This file contains  data definitions and prototypes 
  *  that define one instance of the  compact flash interface.
  * 
  *  Copyright (c) Marvell Semiconductor, Inc., 2003-2005
  */

/********************************************************
Change log:
	09/29/05: Add Doxygen format comments
	
********************************************************/

#ifndef _IF_CF_H_
#define _IF_CF_H_

#include  "cfio_io.h"


/*************************************************************************
                              PUBLIC DEFINITIONS
 *************************************************************************/
// Host Control Registers (HCR) Offset
#define CF_HCR_HOST_STATUS        0x00000000
#define CF_HCR_CARD_INT_CAUSE     0x00000002
#define CF_HCR_HOST_INT_MASK      0x00000004
#define CF_HCR_READ_BASE_LOW      0x00000008
#define CF_HCR_READ_BASE_HIGH     0x0000000A
#define CF_HCR_WRITE_BASE_LOW     0x0000000C
#define CF_HCR_WRITE_BASE_HIGH    0x0000000E
#define CF_HCR_IO_READ_PORT       0x00000010
#define CF_HCR_IO_CMD_READ_PORT   0x00000012
#define CF_HCR_IO_WRITE_LEN       0x00000014
#define CF_HCR_IO_WRITE_PORT      0x00000016
#define CF_HCR_IO_CMD_WRITE_LEN   0x00000018
#define CF_HCR_IO_CMD_WRITE_PORT  0x0000001A

#define CF_HCR_SCRATCH_PORT       0x0000003F
#define CF_HCR_CIS_ADDR_PORT      0x00000046
#define CF_HCR_CIS_DATA_PORT      0x00000048
#define CF_HCR_IO_GBUS_REG_READ   0x0000004C
#define CF_HCR_IO_GBUS_REG_WRITE  0x0000004E

typedef struct {
  u32 status;
  u32 int_cause;
  u32 int_mask;
  u32 raddr0;
  u32 raddr1;
  u32 waddr0;
  u32 waddr1;
  u32 io_data_read;
  u32 io_cmd_read;
  u32 io_data_write_len;
  u32 io_data_write;
  u32 io_cmd_write_len;
  u32 io_cmd_write;
  u32 scratch;
  u32 cis_addr;
  u32 cis_data;
  u32 gbus_read;
  u32 gbus_write;
}  host_reg;

// Card Control Registers (CCR) Offset
#define CF_CCR_PRODUCT_ID             0x0000001C
#define CF_CCR_CARD_STATUS            0x00000020
#define CF_CCR_HOST_INT_CAUSE         0x00000022
#define CF_CCR_IO_READ_LEN            0x00000024
#define CF_CCR_SQ_READ_BASE_LOW       0x00000028
#define CF_CCR_SQ_READ_BASE_HIGH      0x0000002A
#define CF_CCR_SQ_WRITE_BASE_LOW      0x0000002C
#define CF_CCR_SQ_WRITE_BASE_HIGH     0x0000002E
#define CF_CCR_IO_CMD_READ_LEN        0x00000030
#define CF_CCR_SQ_CMD_READ_BASE_LOW   0x00000034
#define CF_CCR_SQ_CMD_READ_BASE_HIGH  0x00000036
#define CF_CCR_SQ_CMD_WRITE_BASE_LOW  0x00000038
#define CF_CCR_SQ_CMD_WRITE_BASE_HIGH 0x0000003A
#define CF_CCR_CFG_REG_BASE_ADR       0x0000003C
#define CF_CCR_CARD_CFG               0x0000003E
#define CF_CCR_SCRATCH_PORT           0x0000003F
#define CF_CCR_TX_FRAME_SEQ_NUM       0x00000040
#define CF_CCR_TX_FRAME_STATUS        0x00000042
#define CF_CCR_CARD_INT_MASK          0x00000044
#define CF_CCR_CIS_ADR_PORT           0x00000046
#define CF_CCR_CIS_DATA_PORT          0x00000048

typedef struct {
  u32 product_id;
  u32 status;
  u32 int_cause;
  u32 io_data_len;
  u32 sq_raddr0;
  u32 sq_raddr1;
  u32 sq_waddr0;
  u32 sq_waddr1;
  u32 io_cmd_read_len;
  u32 sq_cmd_raddr0;
  u32 sq_cmd_raddr1;
  u32 sq_cmd_waddr0;
  u32 sq_cmd_waddr1;
  u32 cfg_base;
  u32 card_cfg;
  u32 scratch;
  u32 tx_seq;
  u32 tx_stat;
  u32 int_mask;
  u32 cis_addr;
  u32 cis_data;
}  card_reg;

typedef struct {
  host_reg host;
  card_reg card;
} cfreg;

// Bit definition for CF_HCR_HOST_STATUS (Host Status)
#define CF_HCR_HS_TxDnLdOvr       B_BIT_0
#define CF_HCR_HS_RxUpLdOvr       B_BIT_1
#define CF_HCR_HS_CmdDnLdOvr      B_BIT_2
#define CF_HCR_HS_PwrDown         B_BIT_3
#define CF_HCR_HS_HstEvent        B_BIT_4
#define CF_HCR_HS_FlushDataFifo   B_BIT_5
#define CF_HCR_HS_MASK      0x3F

// Bit definition for CF_HCR_CARD_INT_CAUSE (Card Interrupt Cause)
#define CF_HCR_CIC_TxDnLdOvr      W_BIT_0
#define CF_HCR_CIC_RxUpLdOvr      W_BIT_1
#define CF_HCR_CIC_CmdDnLdOvr     W_BIT_2
#define CF_HCR_CIC_PwrDown        W_BIT_3
#define CF_HCR_CIC_HstEvent       W_BIT_4
#define CF_HCR_CIC_MASK           0x001F

// Bit definition for CF_HCR_HOST_INT_MASK (Host Interrupt Mask)
#define CF_HCR_HIM_TxDnLdRdy      W_BIT_0
#define CF_HCR_HIM_RxUpLdRdy      W_BIT_1
#define CF_HCR_HIM_CmdDnLdRdy     W_BIT_2
#define CF_HCR_HIM_CmdRspRdy      W_BIT_3
#define CF_HCR_HIM_CardEvent      W_BIT_4
#define CF_HCR_HIM_MASK           0x001F

// Bit definition for CF_CCR_CARD_STATUS (Card Status)
#define CF_CCR_CS_TxDnLdRdy       W_BIT_0
#define CF_CCR_CS_RxUpLdRdy       W_BIT_1
#define CF_CCR_CS_CmdDnLdRdy      W_BIT_2
#define CF_CCR_CS_CmdRspRdy       W_BIT_3
#define CF_CCR_CS_CardEvent       W_BIT_4
#define CF_CCR_CS_PwrDwn          W_BIT_8
#define CF_CCR_CS_MACErr          W_BIT_9
#define CF_CCR_CS_802_11LnkUp     W_BIT_10
#define CF_CCR_CS_10btLnkUp       W_BIT_11
#define CF_CCR_CS_100btLnkUp      W_BIT_12
#define CF_CCR_CS_LnkStsChg       W_BIT_13
#define CF_CCR_CS_TxFrmStsChg     W_BIT_14
#define CF_CCR_CS_ReadCISRdy      W_BIT_15
#define CF_CCR_CS_MASK            0xFF1F
#define CF_CCR_CS_STATUS_MASK     0x7f00

// Bit definition for CF_CCR_HOST_INT_CAUSE (Host Interrupt Cause)
#define CF_CCR_HIC_TxDnLdRdy      W_BIT_0
#define CF_CCR_HIC_RxUpLdRdy      W_BIT_1
#define CF_CCR_HIC_CmdDnLdRdy     W_BIT_2
#define CF_CCR_HIC_CmdRspRdy      W_BIT_3
#define CF_CCR_HIC_CardEvent      W_BIT_4
#define CF_CCR_HIC_MASK           0x001F

// Bit definition for CF_CCR_TX_FRAME_STATUS (Tx Frame Status)
#define CF_CCR_TFS_SqDmaOvr       W_BIT_0
#define CF_CCR_TFS_TxFrmSent      W_BIT_1
#define CF_CCR_TFS_RtyLmtExcd     W_BIT_2
#define CF_CCR_TFS_TimeOut        W_BIT_3
#define CF_CCR_TFS_MASK           0x000F

// Frame status also returns link speed in bits 4 through 7. 
// They will be filled in by FW to correspond with the link speed but 
// in a different translation.
// Once shifted down to low order nibble, this is the translation.
#define FRAME_STATUS_LINK_SPEED_0mbps     0
#define FRAME_STATUS_LINK_SPEED_1mbps     1
#define FRAME_STATUS_LINK_SPEED_2mbps     2
#define FRAME_STATUS_LINK_SPEED_5dot5mbps 3
#define FRAME_STATUS_LINK_SPEED_10mbps    4
#define FRAME_STATUS_LINK_SPEED_11mbps    5
#define FRAME_STATUS_LINK_SPEED_22mbps    6

// Bit definition for CF_CCR_CARD_INT_MASK (Card Interrupt Mask)
#define CF_CCR_CIM_TxDnLdOvr      W_BIT_0
#define CF_CCR_CIM_RxUpLdOvr      W_BIT_1
#define CF_CCR_CIM_CmdDnLdOvr     W_BIT_2
#define CF_CCR_CIM_PwrDown        W_BIT_3
#define CF_CCR_CIM_HstEvent       W_BIT_4
#define CF_CCR_CIM_MASK           0x001F

// Define Host to card event code used by CF_HCR_SCRATCH_PORT
#define CF_HCR_SP_RxUpLdOvr       B_BIT_0

// Scratch register status definitions
// boot loader is ready to begin firmware download
#define CF_SCRATCH_BOOT_WAITING           0xc3
// boot loader is ready to begin host boot download
#define CF_SCRATCH_HOST_BOOT_WAITING      0x00
// Host has completed downloading a 256 byte block
#define CF_SCRATCH_HOST_BLOCK_READY       0x55
// boot loader as completed moving 256 byte block to memory
#define CF_SCRATCH_BOOT_BLOCK_COMPLETE    0xaa
// Host has finished downloading firmware
#define CF_SCRATCH_HOST_DOWNLOAD_COMPLETE 0x00
// Firmware is up and running
#define CF_SCRATCH_FIRMWARE_READY         0x5a
#define CF_SCRATCH_DEEPSLEEP_EXIT         0xbb

#endif  /* _IF_CF_H_ */
