/* 
 * include/asm-arm/arch-pxa/htcbeetles-gpio.h
 * History:
 *
 * 2004-12-10 Michael Opdenacker. Wrote down GPIO settings as identified by Jamey Hicks.
 *            Reused the h2200-gpio.h file as a template.
 */

#ifndef _HTCBEETLES_GPIO_H_
#define _HTCBEETLES_GPIO_H_

#include <asm/arch/pxa-regs.h>

#define GET_HTCBEETLES_GPIO(gpio) \
	(GPLR(GPIO_NR_HTCBEETLES_ ## gpio) & GPIO_bit(GPIO_NR_HTCBEETLES_ ## gpio))

#define SET_HTCBEETLES_GPIO(gpio, setp) \
do { \
if (setp) \
	GPSR(GPIO_NR_HTCBEETLES_ ## gpio) = GPIO_bit(GPIO_NR_HTCBEETLES_ ## gpio); \
else \
	GPCR(GPIO_NR_HTCBEETLES_ ## gpio) = GPIO_bit(GPIO_NR_HTCBEETLES_ ## gpio); \
} while (0)

#define SET_HTCBEETLES_GPIO_N(gpio, setp) \
do { \
if (setp) \
	GPCR(GPIO_NR_HTCBEETLES_ ## gpio ## _N) = GPIO_bit(GPIO_NR_HTCBEETLES_ ## gpio ## _N); \
else \
	GPSR(GPIO_NR_HTCBEETLES_ ## gpio ## _N) = GPIO_bit(GPIO_NR_HTCBEETLES_ ## gpio ## _N); \
} while (0)

#define HTCBEETLES_IRQ(gpio) \
	IRQ_GPIO(GPIO_NR_HTCBEETLES_ ## gpio)
	
#define GPIO_NR_HTCBEETLES_KEY_ON_N			 0
#define GPIO_NR_HTCBEETLES_GP_RST_N			 1

#define GPIO_NR_HTCBEETLES_ASIC3_EXT_INT		 9
#define GPIO_NR_HTCBEETLES_ASIC3_SDIO_INT_N		13

#define GPIO_NR_HTCBEETLES_TOUCHPANEL_IRQ_N		115

/* TODO: should be checked */

#define GPIO_NR_HTCBEETLES_TOUCHSCREEN_SPI_CLK_MD	(23 | GPIO_ALT_FN_2_IN)
#define GPIO_NR_HTCBEETLES_TOUCHSCREEN_SPI_CS_N_MD	(24 | GPIO_ALT_FN_2_IN)
#define GPIO_NR_HTCBEETLES_TOUCHSCREEN_SPI_DO_MD	(25 | GPIO_ALT_FN_2_OUT)
#define GPIO_NR_HTCBEETLES_TOUCHSCREEN_SPI_DI_MD	(26 | GPIO_ALT_FN_1_IN)

#define GPIO_NR_HTCBEETLES_I2S_BCK_MD		(28 | GPIO_ALT_FN_1_OUT)
#define GPIO_NR_HTCBEETLES_I2S_DIN_MD		(29 | GPIO_ALT_FN_2_IN)
#define GPIO_NR_HTCBEETLES_I2S_DOUT_MD		(30 | GPIO_ALT_FN_1_OUT)
#define GPIO_NR_HTCBEETLES_I2S_SYNC_MD		(31 | GPIO_ALT_FN_1_OUT)

#define GPIO_NR_HTCBEETLES_COM_RXD_MD		(34 | GPIO_ALT_FN_1_IN)
#define GPIO_NR_HTCBEETLES_COM_CTS_MD		(35 | GPIO_ALT_FN_1_IN)

#define GPIO_NR_HTCBEETLES_COM_TXD_MD		(39 | GPIO_ALT_FN_2_OUT)
#define GPIO_NR_HTCBEETLES_COM_RTS_MD		(41 | GPIO_ALT_FN_2_OUT)

#define GPIO_NR_HTCBEETLES_BT_RXD_MD		(42 | GPIO_ALT_FN_1_IN)
#define GPIO_NR_HTCBEETLES_BT_TXD_MD		(43 | GPIO_ALT_FN_2_OUT)
#define GPIO_NR_HTCBEETLES_BT_UART_CTS_MD		(44 | GPIO_ALT_FN_1_IN)
#define GPIO_NR_HTCBEETLES_BT_UART_RTS_MD		(45 | GPIO_ALT_FN_2_OUT)

#define GPIO_NR_HTCBEETLES_STD_RXD_MD		(46 | GPIO_ALT_FN_2_IN)
#define GPIO_NR_HTCBEETLES_STD_TXD_MD		(47 | GPIO_ALT_FN_1_OUT)

#define GPIO_NR_HTCBEETLES_POE_N_MD			(48 | GPIO_ALT_FN_2_OUT | GPIO_DFLT_HIGH)
#define GPIO_NR_HTCBEETLES_PWE_N_MD			(49 | GPIO_ALT_FN_2_OUT | GPIO_DFLT_HIGH)

#define GPIO_NR_HTCBEETLES_I2S_SYSCLK_MD		(113 | GPIO_ALT_FN_1_OUT)

#define GPIO_NR_HTCBEETLES_PWM1OUT_MD		(115 | GPIO_ALT_FN_3_OUT)

#define GPIO_NR_HTCBEETLES_I2C_SCL_MD		(117 | GPIO_ALT_FN_1_OUT)
#define GPIO_NR_HTCBEETLES_I2C_SDA_MD		(118 | GPIO_ALT_FN_1_OUT)

#endif /* _HTCBEETLES_GPIO_H */
