/* 
 * include/asm-arm/arch-pxa/htcmagician-gpio.h
 * History:
 *
 * 2004-12-10 Michael Opdenacker. Wrote down GPIO settings as identified by Jamey Hicks.
 *            Reused the h2200-gpio.h file as a template.
 */

#ifndef _HTCMAGICIAN_GPIO_H_
#define _HTCMAGICIAN_GPIO_H_

#include <asm/arch/pxa-regs.h>

#define GET_HTCMAGICIAN_GPIO(gpio) \
	(GPLR(GPIO_NR_HTCMAGICIAN_ ## gpio) & GPIO_bit(GPIO_NR_HTCMAGICIAN_ ## gpio))

#define SET_HTCMAGICIAN_GPIO(gpio, setp) \
do { \
if (setp) \
	GPSR(GPIO_NR_HTCMAGICIAN_ ## gpio) = GPIO_bit(GPIO_NR_HTCMAGICIAN_ ## gpio); \
else \
	GPCR(GPIO_NR_HTCMAGICIAN_ ## gpio) = GPIO_bit(GPIO_NR_HTCMAGICIAN_ ## gpio); \
} while (0)

#define SET_HTCMAGICIAN_GPIO_N(gpio, setp) \
do { \
if (setp) \
	GPCR(GPIO_NR_HTCMAGICIAN_ ## gpio ## _N) = GPIO_bit(GPIO_NR_HTCMAGICIAN_ ## gpio ## _N); \
else \
	GPSR(GPIO_NR_HTCMAGICIAN_ ## gpio ## _N) = GPIO_bit(GPIO_NR_HTCMAGICIAN_ ## gpio ## _N); \
} while (0)

#define HTCMAGICIAN_IRQ(gpio) \
	IRQ_GPIO(GPIO_NR_HTCMAGICIAN_ ## gpio)
	
#define GPIO_NR_HTCMAGICIAN_KEY_ON			0
#define GPIO_NR_HTCMAGICIAN_GP_RST_N			1

#define GPIO_NR_HTCMAGICIAN_USB_DET			9
#define GPIO_NR_HTCMAGICIAN_POWER_DET			10

#define GPIO_NR_HTCMAGICIAN_CIF_DD7			12

#define GPIO_NR_HTCMAGICIAN_SSPSFRM2			14
#define GPIO_NR_HTCMAGICIAN_CS1_N			15

#define GPIO_NR_HTCMAGICIAN_CIF_DD6			17
#define GPIO_NR_HTCMAGICIAN_RDY				18

#define GPIO_NR_HTCMAGICIAN_PHONE_START			19

#define GPIO_NR_HTCMAGICIAN_KP_MKOUT7			22
#define GPIO_NR_HTCMAGICIAN_SPI_CLK			23
#define GPIO_NR_HTCMAGICIAN_SPI_CS_N			24
#define GPIO_NR_HTCMAGICIAN_SPI_DO			25
#define GPIO_NR_HTCMAGICIAN_SPI_DI			26

#define GPIO_NR_HTCMAGICIAN_USBC_DETECT			27
#define GPIO_NR_HTCMAGICIAN_I2S_BCK			28
#define GPIO_NR_HTCMAGICIAN_I2S_DIN			29
#define GPIO_NR_HTCMAGICIAN_I2S_DOUT			30
#define GPIO_NR_HTCMAGICIAN_I2S_SYNC			31

#define GPIO_NR_HTCMAGICIAN_RS232_ON			32
#define GPIO_NR_HTCMAGICIAN_CS5_N			33

#define GPIO_NR_HTCMAGICIAN_COM_RXD			34
#define GPIO_NR_HTCMAGICIAN_COM_CTS			35
#define GPIO_NR_HTCMAGICIAN_KP_MKIN7			36 #COM_DCD
#define GPIO_NR_HTCMAGICIAN_KEY_PHONE_HANGUP	37
#define GPIO_NR_HTCMAGICIAN_KEY_CONTACTS		38
#define GPIO_NR_HTCMAGICIAN_COM_TXD			39
#define GPIO_NR_HTCMAGICIAN_KP_MKOUT6			40
#define GPIO_NR_HTCMAGICIAN_COM_RTS			41
#define GPIO_NR_HTCMAGICIAN_BT_RXD			42
#define GPIO_NR_HTCMAGICIAN_BT_TXD			43
#define GPIO_NR_HTCMAGICIAN_BT_UART_CTS			44
#define GPIO_NR_HTCMAGICIAN_BT_UART_RTS			45

#define GPIO_NR_HTCMAGICIAN_ST_RXD			46
#define GPIO_NR_HTCMAGICIAN_ST_TXD			47

#define GPIO_NR_HTCMAGICIAN_POE_N			48
#define GPIO_NR_HTCMAGICIAN_PWE_N			49
#define GPIO_NR_HTCMAGICIAN_CIF_DD3			50
#define GPIO_NR_HTCMAGICIAN_CIF_DD2			51
#define GPIO_NR_HTCMAGICIAN_CIF_DD4			52

#define GPIO_NR_HTCMAGICIAN_CIF_MCLK			53
#define GPIO_NR_HTCMAGICIAN_CIF_PCLK			54
#define GPIO_NR_HTCMAGICIAN_CIF_DD1			55

#define GPIO_NR_HTCMAGICIAN_LDD0			58
#define GPIO_NR_HTCMAGICIAN_LDD1			59
#define GPIO_NR_HTCMAGICIAN_LDD2			60
#define GPIO_NR_HTCMAGICIAN_LDD3			61
#define GPIO_NR_HTCMAGICIAN_LDD4			62
#define GPIO_NR_HTCMAGICIAN_LDD5			63
#define GPIO_NR_HTCMAGICIAN_LDD6			64
#define GPIO_NR_HTCMAGICIAN_LDD7			65
#define GPIO_NR_HTCMAGICIAN_LDD8			66
#define GPIO_NR_HTCMAGICIAN_LDD9			67
#define GPIO_NR_HTCMAGICIAN_LDD10			68
#define GPIO_NR_HTCMAGICIAN_LDD11			69
#define GPIO_NR_HTCMAGICIAN_LDD12			70
#define GPIO_NR_HTCMAGICIAN_LDD13			71
#define GPIO_NR_HTCMAGICIAN_LDD14			72
#define GPIO_NR_HTCMAGICIAN_LDD15			73

#define GPIO_NR_HTCMAGICIAN_LFCLK_RD			74
#define GPIO_NR_HTCMAGICIAN_LFCLK_A0			75
#define GPIO_NR_HTCMAGICIAN_LFCLK_WR			76
#define GPIO_NR_HTCMAGICIAN_LBIAS			77

#define GPIO_NR_HTCMAGICIAN_CS2_N			78
#define GPIO_NR_HTCMAGICIAN_CS3_N			79
#define GPIO_NR_HTCMAGICIAN_CS4_N			80
#define GPIO_NR_HTCMAGICIAN_CIF_DD0			81
#define GPIO_NR_HTCMAGICIAN_CIF_DD5			82

#define GPIO_NR_HTCMAGICIAN_IR_ON			83

#define GPIO_NR_HTCMAGICIAN_CIF_LV			84
#define GPIO_NR_HTCMAGICIAN_CIF_FV			85

#define GPIO_NR_HTCMAGICIAN_LCD1			86
#define GPIO_NR_HTCMAGICIAN_LCD2			87

#define GPIO_NR_HTCMAGICIAN_KEY_CALENDAR		90
#define GPIO_NR_HTCMAGICIAN_KEY_CAMERA		91
#define GPIO_NR_HTCMAGICIAN_KEY_UP			93
#define GPIO_NR_HTCMAGICIAN_KEY_DOWN			94
#define GPIO_NR_HTCMAGICIAN_KEY_LEFT			95
#define GPIO_NR_HTCMAGICIAN_KEY_RIGHT		96
#define GPIO_NR_HTCMAGICIAN_KEY_ENTER		97
#define GPIO_NR_HTCMAGICIAN_KEY_RECORD			98
#define GPIO_NR_HTCMAGICIAN_HEADPHONE_IN		99
#define GPIO_NR_HTCMAGICIAN_KEY_VOLUMEUP		100
#define GPIO_NR_HTCMAGICIAN_KEY_VOLUMEDOWN 	101
#define GPIO_NR_HTCMAGICIAN_KEY_PHONE_LIFT		102
#define GPIO_NR_HTCMAGICIAN_KP_MKOUT0			103
#define GPIO_NR_HTCMAGICIAN_KP_MKOUT1			104
#define GPIO_NR_HTCMAGICIAN_KP_MKOUT2			105
#define GPIO_NR_HTCMAGICIAN_KP_MKOUT3			106
#define GPIO_NR_HTCMAGICIAN_KP_MKOUT4			107
#define GPIO_NR_HTCMAGICIAN_KP_MKOUT5			108

#define GPIO_NR_HTCMAGICIAN_PHONE_OFF			110

#define GPIO_NR_HTCMAGICIAN_USB_PUEN			112
#define GPIO_NR_HTCMAGICIAN_I2S_SYSCLK			113

//#define GPIO_NR_HTCMAGICIAN_PWM_OUT1			115
//#define GPIO_NR_HTCMAGICIAN_TOUCHSCREEN_PEN           115
#define GPIO_NR_HTCMAGICIAN_TOUCHPANEL_IRQ_N		115

#define GPIO_NR_HTCMAGICIAN_I2C_SCL			117
#define GPIO_NR_HTCMAGICIAN_I2C_SDA			118

#if 0
#define GPIO_NR_HTCMAGICIAN_WLAN_IRQ_N
#define GPIO_NR_HTCMAGICIAN_CPU_BATT_FAULT_N
#define GPIO_NR_HTCMAGICIAN_LCD_RESET_N
#define GPIO_NR_HTCMAGICIAN_ASIC3_RESET_N
#define GPIO_NR_HTCMAGICIAN_CHARGE_EN_N
#define GPIO_NR_HTCMAGICIAN_EARPHONE_DET_N
#define GPIO_NR_HTCMAGICIAN_USB_PUEN
#define GPIO_NR_HTCMAGICIAN_WLAN_RESET_N
#define GPIO_NR_HTCMAGICIAN_FLASH_VPEN
#define GPIO_NR_HTCMAGICIAN_BATT_OFF
#define GPIO_NR_HTCMAGICIAN_USB_CHARGE_RATE
#define GPIO_NR_HTCMAGICIAN_BL_DETECT_N
#define GPIO_NR_HTCMAGICIAN_AUTO_SENSE	/* to backlight circuit */
#define GPIO_NR_HTCMAGICIAN_LCD_LVDD_3V3_ON
#define GPIO_NR_HTCMAGICIAN_LCD_AVDD_3V3_ON
#define GPIO_NR_HTCMAGICIAN_LCD_N2V7_7V3_ON
#define GPIO_NR_HTCMAGICIAN_USB2_DREQ
#define GPIO_NR_HTCMAGICIAN_CPU_HW_RESET_N
#endif

/* TODO: should be checked */

#define GPIO_NR_HTCMAGICIAN_TOUCHSCREEN_SPI_CLK_MD	(23 | GPIO_ALT_FN_2_IN)
#define GPIO_NR_HTCMAGICIAN_TOUCHSCREEN_SPI_CS_N_MD	(24 | GPIO_ALT_FN_2_IN)
#define GPIO_NR_HTCMAGICIAN_TOUCHSCREEN_SPI_DO_MD	(25 | GPIO_ALT_FN_2_OUT)
#define GPIO_NR_HTCMAGICIAN_TOUCHSCREEN_SPI_DI_MD	(26 | GPIO_ALT_FN_1_IN)

#define GPIO_NR_HTCMAGICIAN_I2S_BCK_MD		(28 | GPIO_ALT_FN_1_OUT)
#define GPIO_NR_HTCMAGICIAN_I2S_DIN_MD		(29 | GPIO_ALT_FN_2_IN)
#define GPIO_NR_HTCMAGICIAN_I2S_DOUT_MD		(30 | GPIO_ALT_FN_1_OUT)
#define GPIO_NR_HTCMAGICIAN_I2S_SYNC_MD		(31 | GPIO_ALT_FN_1_OUT)

#define GPIO_NR_HTCMAGICIAN_COM_RXD_MD		(34 | GPIO_ALT_FN_1_IN)
#define GPIO_NR_HTCMAGICIAN_COM_CTS_MD		(35 | GPIO_ALT_FN_1_IN)

#define GPIO_NR_HTCMAGICIAN_COM_TXD_MD		(39 | GPIO_ALT_FN_2_OUT)
#define GPIO_NR_HTCMAGICIAN_COM_RTS_MD		(41 | GPIO_ALT_FN_2_OUT)

#define GPIO_NR_HTCMAGICIAN_BT_RXD_MD		(42 | GPIO_ALT_FN_1_IN)
#define GPIO_NR_HTCMAGICIAN_BT_TXD_MD		(43 | GPIO_ALT_FN_2_OUT)
#define GPIO_NR_HTCMAGICIAN_BT_UART_CTS_MD		(44 | GPIO_ALT_FN_1_IN)
#define GPIO_NR_HTCMAGICIAN_BT_UART_RTS_MD		(45 | GPIO_ALT_FN_2_OUT)

#define GPIO_NR_HTCMAGICIAN_STD_RXD_MD		(46 | GPIO_ALT_FN_2_IN)
#define GPIO_NR_HTCMAGICIAN_STD_TXD_MD		(47 | GPIO_ALT_FN_1_OUT)

#define GPIO_NR_HTCMAGICIAN_POE_N_MD			(48 | GPIO_ALT_FN_2_OUT | GPIO_DFLT_HIGH)
#define GPIO_NR_HTCMAGICIAN_PWE_N_MD			(49 | GPIO_ALT_FN_2_OUT | GPIO_DFLT_HIGH)

#define GPIO_NR_HTCMAGICIAN_I2S_SYSCLK_MD		(113 | GPIO_ALT_FN_1_OUT)

#define GPIO_NR_HTCMAGICIAN_PWM1OUT_MD		(115 | GPIO_ALT_FN_3_OUT)

#define GPIO_NR_HTCMAGICIAN_I2C_SCL_MD		(117 | GPIO_ALT_FN_1_OUT)
#define GPIO_NR_HTCMAGICIAN_I2C_SDA_MD		(118 | GPIO_ALT_FN_1_OUT)

#endif /* _HTCMAGICIAN_GPIO_H */
