##
#	Text to Doc converter for 3Com PalmPilots
#	config/config.mk
#
#	Copyright (C) 1998  Paul J. Lucas
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
# 
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
# 
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##

##
#	Note: If you later redefine any of these variables, you *MUST* first
#	do a "make distclean" before you do another "make".
##

##
# Build stuff
#
#	MAKE	The 'make' software you are using; usually "make".
#
#	SHELL	The shell to spawn for subshells; usually "/bin/sh".
#
#	STRIP	The command to strip symbolic informaiton from executables;
#		usually "strip".  You can leave this defined even if your OS
#		doesn't have it or any equivalent since any errors from this
#		command are ignored in the Makefiles.
#
#	RM	The command to remove files recursively and ignore errors;
#		usually "rm -fr".
##
MAKE=		make
SHELL=		/bin/sh
STRIP=		strip
RM=		rm -fr

##
# C compiler
#
#	CC	C compiler.
#
#	CCFLAGS	Flags for C compiler:
#		-g	Include symbol-table information in object file.
#		-O	Turn optimization on.  Some implementations allow a
#			digit after the O for optimization level.
##
CC=		gcc
CCFLAGS=	-g #-O3 #-g

##
# install
#
#	INSTALL	Install command; usually "$(ROOT)/install-sh".
#	I_ROOT	Top-level directory of install tree.
#	I_BIN	Where executables are installed.
#	I_MAN	Where manual pages are installed.
#	I_OWNER	Owner of installed files.
#	I_GROUP	Group of installed files.
#	I_XMODE	File permissions for eXecutables.
#	I_MODE	File permissions for regular files (non executables).
#	MKDIR	Command used to create a directory.
##
INSTALL=	$(ROOT)/install-sh
I_ROOT=		/usr/local/txt2pdbdoc
I_BIN=		$(I_ROOT)/bin
I_MAN=		$(I_ROOT)/man
I_OWNER=	-o bin
I_GROUP=	-g bin
I_XMODE=	-m 755
I_MODE=		-m 644
MKDIR=		$(INSTALL) $(I_OWNER) $(I_GROUP) $(I_XMODE) -d

##
# nroff -- for generating plain text files from manual pages
# troff -- for generating PostScript files from manual pages
#
#	TBL	Command for processing 'tbl' input to [nt]roff.
#	TO_TXT	Command for converting nroff output to plain text.
#	TO_PS	Command for converting troff output to PostScript.
##
TBL=		tbl
NROFF=		nroff
NROFF_FLAGS=	-man
TO_TXT=		col -b
TROFF=		troff
TROFF_FLAGS=	-man -Tpost
TO_PS=		/usr/lib/lp/postscript/dpost

########## You shouldn't have to change anything below this line. #############

# ROOT is defined by the Makefile including this.

CONFIG=		$(ROOT)/config
MAN=		$(ROOT)/man
