#include <stdio.h>
#include <X10/Xlib.h>
#define AUX extern
#define READFILE extern
#define LKUPS extern
#include "prsdefs.h"
#include "structs.h"
#include "lkups.h"
#include "defs.h"
#define VDISC extern
#include "vdisc.h"

extern Screen *screen_sets[Screen_sets];
extern make_tk_widget();

#define MATCH 0

resolve_names()
{
  char 		*funcname = "resolve_names";
  Screen 	*s;
  Screenlist    *sl;
  Element 	*ele, *tele;
  Package 	*pck, *tpck;
  Map		*m;
  DimRep        *rep;
  int 		i,c,j,n;
  char          *discname[MaxDiscs];
  Mapped_items  *vidmaps = 0, *tmpvid;
  char		*p1, line[32],*index(), *gets();

  u$Rpdcount = -1;
  u$Disccount = 0;


/*
*  Resolve Names
*
*  The routine goes through the list of packages and resolves the
*  names referenced by that package.  First it finds the packages in
*  the `unext' slot.  It creates closed loops of packages with home
*  packages flagged.
* 
*  Then it finds the window set listed in `screen_name'.
*  The windows have already been created by Makewindows() before coming
*  here.
*
*  Once it has the set of windows to work from, it starts down
*  the list of elements in the package.
*  For each element, it resolves the `next' name and finds the display
*  window for that element in the list of windows held by the parent
*  package.
*
*  If the element is a widget of some sort, then it goes down the list
*  of mappings to actually build the widgets and get the window pointers
*  for them.  Coming in, the data for the widget is held in the
*  `map->simple.w' slot, as a pointer to a struct of the appropriate type.
*/

	pck = first_package;

	while(pck != 0)
	{
	        for(i = 0; i < MaxDims && pck->dimension[i]; ++i)
	        {
		        pck->position[i] = pck->dimension[i]->initial;
	         }

  		if(strlen(pck->nextname))
		{
    		    tpck = first_package;
    		    while(strcmp(pck->nextname, tpck->name) != MATCH)
      		    {
			  if((tpck = tpck->next) == 0)
	  		  {
	    		    printf("%s: can't match next: %s in package %s\n"
		   		,funcname, pck->nextname, pck->name);
	    		    exit(1);
	  		   }
      	 	     }
    		    pck->unext = tpck;
		    pck->unext->uprev = pck;
  		 }
		else				/* close loop */
		{
			for(tpck = pck; tpck->uprev; tpck = tpck->uprev);
			tpck->uprev = pck;
			pck->unext = tpck;
		 }
 

		if(strlen(pck->screen_name))
		{
  		   	for(i=0; i < Screen_sets; ++i)
			{
      				if(strcmp(pck->screen_name, 
					screen_sets[i]->name) == MATCH)
				{
      					break;
    				 }
			 }

			if(i < Screen_sets)
			{
  				pck->window = screen_sets[i];
			 }
    			else
			{
      		          	printf("%s: can't match screen named %s in package %s\n",funcname, pck->screen_name, pck->name);
      			  	exit(1);
    			 }
   			 
		 }
		else
		{
  			printf("%s: missing screen name in package %s\n"
				,funcname,pck->name);
  			exit(1);
		 }

/*
*  Take care of the representations.
*/
		rep = pck->reps;
		while( rep != 0 )
		{
    		    	tpck = first_package;
    		    	while(strcmp(rep->packname, tpck->name) != MATCH)
      		    	{
			  	if((tpck = tpck->next) == 0)
	  		  	{
	    		     		printf("%s: can't match package `%s'\n"
		   		    	    ,funcname, rep->packname );
	    		    		exit(1);
	  		   	 }
      	 	     	 }
		    	rep->p = tpck;
			for(i = 0; i < tpck->ndims; ++i)
			{
      				if(strcmp(rep->dimname,
					tpck->dimension[i]->name) == MATCH)
				{
      					break;
    				 }
			 }

			if(i < tpck->ndims)
			{
				rep->d = tpck->dimension[i];
				c = rep->d->initial;
				if(!rep->extent) 
				    rep->extent = rep->d->maxi - rep->d->mini;
			        rep->low = (c/rep->extent)*rep->extent;
				rep->high = rep->low + rep->extent;
				if(rep->high > rep->d->maxi)
				{
				    rep->high = rep->d->maxi;
				    rep->low = rep->high - rep->extent;
	 			 }
				rep->next = tpck->dimension[i]->rep;
				tpck->dimension[i]->rep = rep;
			 }
    			else
			{
      		          	printf("%s: can't match dimension `%s'\n"
				    ,funcname, rep->dimname);
      			  	exit(1);
    			 }

			rep = rep->tmp;
		 }

/*
*   For each element in the current package, check to see if it's a 
*   widget type.  If so, create the widget(s).  Then, for all elements,
*   find out what window they're supposed to be mapped into.
*/
		ele = pck->element;
		while(ele != 0)
		{
	        	sl = ele->screen;
			while(sl)
			{				
				s = pck->window;
				while(strcmp(sl->name, s->name) != MATCH)
			        {
					if((s = s->next) == 0)
					{
					      printf("%s: can't match screen: %s in element %s\n"
					           ,funcname, sl->name
						   , ele->name);
					      exit(1);
					  }
				  }
				sl->s = s;
				sl = sl->next;
			 }
			if(ele->type == TK_WIDGET)
			{
				m = ele->map;
				while(m != 0)
				{
				        if(m->simple.type > Unused_map)
					{
					    make_tk_widget(ele, m);
					    m = m->simple.next;
					 }
					else free((char *)m); 
				 }
			 }
			if( ele->type == TEXT)
			{
				m = ele->map;
				make_tk_widget(ele,m);
			 }

			if( ele->type == VIDEO || ele->type == STILL )
			{
				m = ele->map;
				while(m != 0)
				{
printf(" map %d with label `%s', volumes now = %d\n",m,m->simple.text,u$Disccount);
					for(i=0; i < u$Disccount && 
					   (strcmp(discname[i],m->simple.text))
					   ;++i);
printf("  i = %d\n",i);
				        if(i >= u$Disccount)
				        {
					  discname[i] = newstr(m->simple.text);
					  ++u$Disccount;
				         }
				    
				     tmpvid = (Mapped_items *)
				         calloc(1, sizeof(Mapped_items));
				     tmpvid->map = m;
				     tmpvid->next = vidmaps;
				     vidmaps = tmpvid;
				     m = m->simple.next;
				  }
			 }

			ele = ele->next;    
  
  		}
	pck = pck->next;
	 
	}


	/*  Having made a list of all videodisc names referenced, now 
	*   associate these names with rpd device numbers.  First get
	*   info on all rpd devices.
	*/
printf(" building device table...\n");
	for(i = 0; i < vdt.ndevs; ++i)
	{
		if(vdt.dev[i].type == RPD_DEV)
		{
			rpdinfo[++u$Rpdcount] = (Rpdspec *)
				calloc(1, sizeof(Rpdspec));
printf("found device `%s'..",vdt.dev[i].name);
			p1 = index(vdt.dev[i].name,'-');
			rpdinfo[u$Rpdcount]->number = atoi(++p1);
			rpdinfo[u$Rpdcount]->devname = newstr(vdt.dev[i].name);
printf("number %d, name %s  dev[%d] %s\n",rpdinfo[u$Rpdcount]->number,rpdinfo[u$Rpdcount]->devname,i,vdt.dev[i].name);
		 }
	 }
printf("done\n");

	if(u$Disccount > 0 && u$Rpdcount == -1)
	{
		fprintf(stderr,
		    "%s Error: Video referenced but no players available!\n"
			,funcname);
	 }

printf("rpdcount = %d\n",u$Rpdcount);
	for(i=0; i < u$Rpdcount + 1; ++i)
	{
		/* see if the disc is out there.. if not, try loading*/
	  	Vdisc_getframe(i + 1);
printf("v$code %d v$val %d, v$err %d\n",v$code,v$val,v$err);
		if( !v$val )
		{
			printf("loading rpd-%d...",i+1);
			Vdisc_load(i+1);
			printf("done\n");
		 }
		if( v$code )
		{
			  printf("RPD-%d NOT RESPONDING, CONTINUING..",i+1);
		 }
	 }

	if(u$Disccount == 1 && u$Rpdcount == 0)
	{
		fprintf(stderr,
		  "%s Assumption: Videodisc `%s' is mounted on device `%s'.\n",
		  funcname, discname[0], rpdinfo[0]->devname);
		rpdinfo[0]->volume = discname[0];
	 }
/*
	else if (u$Disccount == 1 && u$Rpdcount > 0)
	{
		fprintf(stderr,
		  "%s Assumption: Videodisc `%s' is mounted on devices"
			,funcname,discname[0]);
		for(i = 0; i < u$Rpdcount; ++i)
		{
			fprintf(stderr," %s,",rpdinfo[i]->devname);
			rpdinfo[i]->volume = discname[0];
		 }
		fprintf(stderr,"\n Sorry--can't use more than one at present");
	 }
*/
	else
	{
		if (u$Disccount > u$Rpdcount + 1)
		{
			fprintf(stderr,
	   "%s Warning: More videodisc labels named than players available\n",
			funcname);
	 	 }
		fprintf(stderr,
                     "%s: For each videodisc, enter the number of the record/play device:\n",
		      funcname);
		for(i=0; i <= u$Rpdcount; i++)
		{
			fprintf(stderr,"   %d.  %s\n",i,rpdinfo[i]->devname);
		 }
		fprintf(stderr,"\n");
		for(i=0; i < u$Disccount; ++i)
		{
		    fprintf(stderr,"%s: ",discname[i]);
		for(j = 0; j < 10; j++)
		{
			gets(line);
			n = atoi(line);
			if(n >=0 && n <= u$Rpdcount) break;
		 }
		if(j >= 10) exit(1);
		    if(rpdinfo[n]->volume)
		    {
			rpdinfo[++u$Rpdcount] = (Rpdspec *)
				calloc(1, sizeof(Rpdspec));
			rpdinfo[u$Rpdcount]->number = rpdinfo[n]->number;
			rpdinfo[u$Rpdcount]->devname = rpdinfo[n]->devname;
			n = u$Rpdcount;
		     }
 	    	     rpdinfo[n]->volume = discname[i];

		    fprintf(stderr,
	  	         "Videodisc `%s' is mounted on device `%s'.\n",
	  	          discname[i], rpdinfo[n]->devname);
		     
	          }
	 }

	/*  Finally, go through the video maps and put in the rpd numbers */

	while(vidmaps)
	{
	  	for(i=0;
	  		i<=u$Rpdcount &&
			strcmp(vidmaps->map->simple.text,rpdinfo[i]->volume);
	      		++i);
		if(i>u$Rpdcount)
		{
			fprintf(stderr,"%s: Error resolving video labels\n",
			    funcname);
		 }
printf("assigning rpd-%d for video map %d\n",rpdinfo[i]->number,vidmaps->map);

		vidmaps->map->simple.rpd = rpdinfo[i]->number;
		vidmaps = vidmaps->next;
	 }
		 
}




Window
findparent(i, name, child)
 int i;  /* i is where to begin in the screen chain */
 char *name, *child;
{
  char *funcname = "findparent";
  Screen *s;
  
  s = screen_sets[i];
  while (s != 0){
    	if(strcmp(name, s->name))
    	{
      		s = s->next;
    	 }
    	else
	{
      		if (s->w) 
		{
			return(s->w);
		 }
      		else
		{
            		printf("%s: can't create child %s before parent %s\n",
		     	    funcname,child,name);
	    		exit(1);
	  	 }
    	 }
   }
 
  printf("%s: can't find window named %s in this set.\n",funcname,name);
  exit(1);    
}



int
makewindows()
{
char *funcname = "makewindows";
Screen *s;
Window parent;
OpaqueFrame frame;
int i, x;

for(i=0;(s = screen_sets[i]);++i)
{
  while(s != 0)
  {
    s->parent = strcmp(s->parentname, "RootWindow") ? 
      (Window) findparent(i,s->parentname,s->name) : RootWindow;
    switch(s->type)
    {


    case WINDOW:
      s->w = XCreateWindow(
		    s->parent,
	            s->x, 
	            s->y, 
	            s->width, 
	            s->height,
	            s->borderwidth,
		    s->border_pixmap,
		    s->background_pixmap
		   );


      if (s->w == 0) {
	printf("%s: can't open opaque window\n", funcname);
	exit(1);
      }
      break;

    case TRANSPARENCY:
      printf("making transparent window named %s\n",s->name);

      s->w = XCreateTransparency(
			   s->parent,
			   s->x,
			   s->y,
			   s->width,
			   s->height  );

        if (s->w == 0) {
	  printf("%s: can't open transparent window\n", funcname);
	  exit(1);
	}

       break;

    case VIDEO:


      s->w = XCreateVideoWindow (
		    s->parent,
	            s->x, 
	            s->y, 
	            s->width, 
	            s->height,
	            s->borderwidth,
		    s->border_pixmap,
		    s->background_pixmap
		   );

      if (s->w == 0) {
	printf("%s: can't open video window\n", funcname);
	exit(1);
      }

        break;

    case STILL:
printf("making still video named %s\n",s->name);

      s->w = XCreateVideoWindow (
		    s->parent,
	            s->x, 
	            s->y, 
	            s->width, 
	            s->height,
	            s->borderwidth,
		    s->border_pixmap,
		    s->background_pixmap
		   );

      if (s->w == 0) {
	printf("%s: can't open video window\n", funcname);
	exit(1);
      }

      break;
    default:
      break;
  }

  s = s->next;
  }
}

}
