/*
 * Decompiled with CFR 0.152.
 */
package cs101.awt;

import cs101.awt.ColorField;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class DisplayField
extends ColorField {
    protected String text;

    public DisplayField(String string, boolean bl, Color color, Color color2) {
        super(bl, new Dimension(25, 25), color, color2);
        this.text = string;
    }

    public void addNotify() {
        super.addNotify();
        this.measure();
    }

    public Dimension getMinimumSize() {
        return this.dim;
    }

    public Dimension getPreferredSize() {
        return this.dim;
    }

    private void measure() {
        Dimension dimension = new Dimension(this.dim);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return;
        }
        this.dim.height = fontMetrics.getHeight() + 16;
        this.dim.width = fontMetrics.stringWidth(this.text) + 20;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(Color.black);
        graphics.drawString(this.text, 10, this.dim.height - 10);
    }

    public void setText(String string) {
        this.text = string;
        this.measure();
        this.repaint();
    }
}

