/*
 * Decompiled with CFR 0.152.
 */
package cs101.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

class GroupPane
extends Canvas
implements MouseListener {
    Dimension size = new Dimension(180, 20);
    ActionListener actionlistener;
    Vector names = new Vector();
    int hilite = -1;

    public GroupPane() {
        this.addMouseListener(this);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionlistener = AWTEventMulticaster.add(this.actionlistener, actionListener);
    }

    public Dimension getMinimumSize() {
        return this.size;
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public int mouseOver(Point point) {
        int n = point.y / 20;
        if (point.y < 0 || n >= this.names.size()) {
            n = -1;
        }
        return n;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.hilite = this.mouseOver(mouseEvent.getPoint());
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mouseOver(mouseEvent.getPoint()) == this.hilite && this.hilite >= 0) {
            if (this.actionlistener != null) {
                String string = (String)this.names.elementAt(this.hilite);
                String string2 = string.substring(0, string.lastIndexOf(" "));
                this.actionlistener.actionPerformed(new ActionEvent(this, 1001, string2));
            }
        } else {
            this.hilite = -1;
        }
        this.repaint();
    }

    public synchronized void paint(Graphics graphics) {
        int n = 0;
        while (n < this.names.size()) {
            if (n == this.hilite) {
                graphics.setColor(Color.lightGray);
                graphics.fill3DRect(0, n * 20, this.size.width, 20, true);
                graphics.setColor(Color.blue);
            } else {
                graphics.setColor(Color.black);
            }
            graphics.drawString((String)this.names.elementAt(n), 3, 20 * n + 16);
            ++n;
        }
    }

    public synchronized void parseGroups(String string) {
        this.names.removeAllElements();
        int n = 0;
        while (n < string.length()) {
            int n2 = string.indexOf("\n", n);
            if (n2 == -1) break;
            String string2 = string.substring(n, n2);
            this.names.addElement(string2);
            n = n2 + 1;
        }
        this.setSize(180, this.names.size() * 20);
        this.repaint();
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionlistener = AWTEventMulticaster.remove(this.actionlistener, actionListener);
    }
}

