/*
 * Decompiled with CFR 0.152.
 */
package cs101.net;

import cs101.net.BabySitter;
import cs101.net.ClientGroup;
import cs101.net.GroupServer;
import cs101.net.Server;
import java.io.IOException;
import java.net.Socket;

class GroupBabySitter
extends BabySitter {
    protected ClientGroup groupID = null;
    protected boolean noteToSelf = false;
    protected String userID = null;
    private static int count = 0;

    public GroupBabySitter(Socket socket, Server server) {
        super(socket, server);
        this.userID = String.valueOf(count++);
    }

    public GroupBabySitter(Socket socket, Server server, String string) {
        super(socket, server);
        this.userID = string;
    }

    public String getUserID() {
        return this.userID;
    }

    protected void processGroupQuery(String string) {
        if (string.equals("!!!GET_GROUPS")) {
            this.send("!!!GROUP_LIST" + ((GroupServer)this.server).getGroupList());
        } else if (string.startsWith("!!!JOIN_GROUP")) {
            this.groupID.removeClient(this);
            this.groupID = null;
            String string2 = string.substring("!!!JOIN_GROUP".length());
            ((GroupServer)this.server).joinGroup(this, string2);
        } else if (string.equals("!!!WANT_ECHO")) {
            this.noteToSelf = true;
        } else if (string.equals("!!!DONT_ECHO")) {
            this.noteToSelf = false;
        } else {
            this.send("FAILED");
        }
    }

    public void run() {
        System.out.println("Server:  BabySitter running");
        this.setGroup(ClientGroup.noGroup);
        while (true) {
            try {
                while (true) {
                    String string;
                    if ((string = (String)this.ois.readObject()) == null || string == "") {
                        this.server.removeBabySitter(this);
                        return;
                    }
                    if (this.groupID == ClientGroup.noGroup) {
                        this.processGroupQuery(string);
                        continue;
                    }
                    if (string.equals("!!!LEAVE_GROUP")) {
                        this.setGroup(ClientGroup.noGroup);
                        this.send("!!!\nSELECT_GROUP");
                        continue;
                    }
                    this.groupID.sendToGroup(string, this);
                }
            }
            catch (IOException iOException) {
                System.out.println("Server:  socket error in run ");
                this.server.removeBabySitter(this);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("GroupServer: cannot find class java.lang.String");
                this.server.removeBabySitter(this);
                continue;
            }
            break;
        }
    }

    protected synchronized void send(String string) {
        try {
            this.oos.writeObject(string);
        }
        catch (IOException iOException) {
            System.out.println("Server:  socket error in send");
            this.server.removeBabySitter(this);
        }
    }

    protected void setGroup(ClientGroup clientGroup) {
        if (this.groupID != null) {
            this.groupID.removeClient(this);
        }
        this.groupID = clientGroup;
        this.groupID.addClient(this);
    }

    protected void stop() {
        this.groupID.removeClient(this);
        super.stop();
    }

    public boolean wantsReflection() {
        return this.noteToSelf;
    }
}

