/*
 * Decompiled with CFR 0.152.
 */
package cs101.net;

import cs101.awt.GroupDialog;
import cs101.net.Client;
import cs101.net.GroupWatcher;
import cs101.net.Wire;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;

public class GroupClientWire
extends Client
implements Wire {
    GroupDialog gd = null;
    String userID = null;
    GroupWatcher gw = null;

    public GroupClientWire() {
        super("18.62.4.201", 8870);
        this.init();
    }

    public GroupClientWire(GroupWatcher groupWatcher) {
        super("18.62.4.201", 8870);
        this.gw = groupWatcher;
        this.init();
    }

    public GroupClientWire(String string, int n) {
        super(string, n);
        this.init();
    }

    public GroupClientWire(String string, int n, GroupWatcher groupWatcher) {
        super(string, n);
        this.gw = groupWatcher;
        this.init();
    }

    protected void connectTo(String string, int n) {
        System.out.println("Client:  trying to connect to " + string + " on port " + n);
        try {
            this.sock = new Socket(string, n);
            this.oos = new ObjectOutputStream(this.sock.getOutputStream());
            this.ois = new ObjectInputStream(this.sock.getInputStream());
        }
        catch (IOException iOException) {
            throw new RuntimeException("Client:  can't establish communication with " + string + " on port " + n);
        }
    }

    public String getUserID() {
        return this.userID;
    }

    private void init() {
        this.gd = new GroupDialog(this);
        this.gd.show();
        this.send("!!!GET_GROUPS");
    }

    public Object readObject() {
        try {
            String string;
            while (true) {
                string = (String)this.ois.readObject();
                if (this.gd != null) {
                    if (string.startsWith("!!!JOINED")) {
                        this.userID = string.substring("!!!JOINED".length());
                        System.out.println("UserID is " + this.userID);
                        this.gd.dispose();
                        this.gd = null;
                        continue;
                    }
                    if (string.equals("!!!GROUPS_CHANGED")) {
                        this.send("!!!GET_GROUPS");
                        continue;
                    }
                    if (string.startsWith("!!!GROUP_LIST")) {
                        this.gd.parseGroups(string);
                        continue;
                    }
                    System.out.println("Received unknown: '" + string + "'");
                    continue;
                }
                if (string.equals("!!!\nSELECT_GROUP")) {
                    this.gd = new GroupDialog(this);
                    this.gd.show();
                    this.send("!!!GET_GROUPS");
                    continue;
                }
                if (string.startsWith("!!!JOINED")) {
                    if (this.gw == null) continue;
                    this.gw.userJoined(string.substring("!!!JOINED".length()));
                    continue;
                }
                if (!string.startsWith("!!!CLIENT_LEFT")) break;
                if (this.gw == null) continue;
                this.gw.userLeft(string.substring("!!!CLIENT_LEFT".length()));
            }
            return string;
        }
        catch (IOException iOException) {
            throw new RuntimeException("GroupClient:  failed to read");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("GroupClient: can't find class java.lang.String");
        }
    }

    public void writeObject(Object object) {
        this.send(object.toString());
    }
}

