/*
 * Decompiled with CFR 0.152.
 */
package cs101.net;

import cs101.net.ClientGroup;
import cs101.net.GroupBabySitter;
import cs101.net.Server;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;

public class GroupServer
extends Server {
    protected Vector groups = new Vector();
    public static final String GET_GROUPS = "!!!GET_GROUPS";
    public static final String JOIN_GROUP = "!!!JOIN_GROUP";
    public static final String LEAVE_GROUP = "!!!LEAVE_GROUP";
    public static final String SELECT_GROUP = "!!!\nSELECT_GROUP";
    public static final String GROUPS_CHANGED = "!!!GROUPS_CHANGED";
    public static final String WANT_ECHO = "!!!WANT_ECHO";
    public static final String DONT_ECHO = "!!!DONT_ECHO";
    public static final String GROUP_LIST = "!!!GROUP_LIST";
    public static final String JOINED = "!!!JOINED";
    public static final String CLIENT_LEFT = "!!!CLIENT_LEFT";
    public static final String FAILED = "FAILED";

    public GroupServer() {
        ClientGroup.noGroup = new ClientGroup("no group", this);
    }

    public ClientGroup findGroup(String string) {
        Enumeration enumeration = this.groups.elements();
        while (enumeration.hasMoreElements()) {
            ClientGroup clientGroup = (ClientGroup)enumeration.nextElement();
            if (!clientGroup.getName().equals(string)) continue;
            return clientGroup;
        }
        return null;
    }

    protected String getGroupList() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.groups.elements();
        while (enumeration.hasMoreElements()) {
            ClientGroup clientGroup = (ClientGroup)enumeration.nextElement();
            stringBuffer.append(String.valueOf(clientGroup.getName()) + " (" + clientGroup.size() + ")\n");
        }
        return stringBuffer.toString();
    }

    public synchronized void joinGroup(GroupBabySitter groupBabySitter, String string) {
        ClientGroup clientGroup = this.findGroup(string);
        if (clientGroup == null) {
            System.out.println("Creating group: " + string);
            clientGroup = new ClientGroup(string, this);
            this.groups.addElement(clientGroup);
        }
        groupBabySitter.setGroup(clientGroup);
        clientGroup.sendToGroup(JOINED + groupBabySitter.getUserID(), null);
        ClientGroup.noGroup.sendToGroup(GROUPS_CHANGED, groupBabySitter);
    }

    public synchronized void removeGroup(ClientGroup clientGroup) {
        System.out.println("Removing group: " + clientGroup.groupName);
        this.groups.removeElement(clientGroup);
    }

    protected void spawnBabySitter(Socket socket) {
        GroupBabySitter groupBabySitter = new GroupBabySitter(socket, this);
        this.babySitters.addElement(groupBabySitter);
    }
}

