/*
 * Decompiled with CFR 0.152.
 */
package cs101.net;

import cs101.awt.ServerDialog;
import cs101.net.Wire;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class ServerWire
implements Wire {
    private Socket sock;
    private ObjectInputStream in;
    private ObjectOutputStream out;
    private boolean verbose;

    public ServerWire() {
        this.verbose = true;
        ServerDialog serverDialog = new ServerDialog();
        serverDialog.ask();
        this.connectTo(serverDialog.getPort());
    }

    public ServerWire(int n) {
        this(n, true);
    }

    public ServerWire(int n, boolean bl) {
        this.verbose = bl;
        this.connectTo(n);
    }

    protected void connectTo(int n) {
        if (this.verbose) {
            System.out.println("Server:  listening on port " + n);
        }
        try {
            ServerSocket serverSocket = new ServerSocket(n);
            this.sock = serverSocket.accept();
            this.in = new ObjectInputStream(this.sock.getInputStream());
            this.out = new ObjectOutputStream(this.sock.getOutputStream());
        }
        catch (IOException iOException) {
            throw new RuntimeException("Server:  can't establish communication on port " + n);
        }
    }

    public void finalize() {
        try {
            this.in.close();
            this.out.close();
            this.sock.close();
        }
        catch (IOException iOException) {}
    }

    public Object readObject() {
        try {
            return this.in.readObject();
        }
        catch (Exception exception) {
            throw new RuntimeException("ServerWire:  failed to read.");
        }
    }

    public void writeObject(Object object) {
        try {
            this.out.writeObject(object);
        }
        catch (IOException iOException) {
            throw new RuntimeException("ServerWire:  failed to write.");
        }
    }
}

