/*
 * Decompiled with CFR 0.152.
 */
package cs101.util;

import java.util.Hashtable;

public abstract class MultiClassLoader
extends ClassLoader {
    private Hashtable classes = new Hashtable();
    private char classNameReplacementChar;
    protected boolean monitorOn = true;
    protected boolean sourceMonitorOn = true;

    public synchronized Class forceLoadClass(String string) throws ClassNotFoundException {
        this.monitor(">> MultiClassLoader.forceLoadClass(" + string + ")");
        byte[] byArray = this.loadClassBytes(string);
        if (byArray == null) {
            throw new ClassNotFoundException();
        }
        Class<?> clazz = this.defineClass(string, byArray, 0, byArray.length);
        if (clazz == null) {
            throw new ClassFormatError();
        }
        this.resolveClass(clazz);
        this.classes.put(string, clazz);
        this.monitor(">> Returning newly loaded class.");
        return clazz;
    }

    protected String formatClassName(String string) {
        if (this.classNameReplacementChar == '\u0000') {
            return String.valueOf(string.replace('.', '/')) + ".class";
        }
        return String.valueOf(string.replace('.', this.classNameReplacementChar)) + ".class";
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, true);
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        this.monitor(">> MultiClassLoader.loadClass(" + string + ", " + bl + ")");
        Class<?> clazz = (Class<?>)this.classes.get(string);
        if (clazz != null) {
            this.monitor(">> returning cached result.");
            this.monitor(">> Replacing cached class " + string);
            return clazz;
        }
        try {
            clazz = super.findSystemClass(string);
            this.monitor(">> returning system class (in CLASSPATH).");
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.monitor(">> Not a system class.");
            byte[] byArray = this.loadClassBytes(string);
            if (byArray == null) {
                throw new ClassNotFoundException();
            }
            clazz = this.defineClass(string, byArray, 0, byArray.length);
            if (clazz == null) {
                throw new ClassFormatError();
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            this.classes.put(string, clazz);
            this.monitor(">> Returning newly loaded class.");
            return clazz;
        }
    }

    protected abstract byte[] loadClassBytes(String var1);

    protected void monitor(String string) {
        if (this.monitorOn) {
            MultiClassLoader.print(string);
        }
    }

    protected static void print(String string) {
        System.out.println(string);
    }

    public void setClassNameReplacementChar(char c) {
        this.classNameReplacementChar = c;
    }
}

