/*
 * Decompiled with CFR 0.152.
 */
package gamefinder;

import gamefinder.GameFinder;
import gamefinder.GameSocket;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;

public class GameServer
implements Runnable {
    Thread anim;
    ServerSocket ss;
    GameFinder gf;
    Vector games = new Vector();

    public GameServer(String name, String desc, int port, int max) {
        try {
            this.ss = new ServerSocket(port);
            this.gf = GameFinder.announce(name, desc, port, max);
            this.anim = new Thread(this);
            this.anim.start();
        }
        catch (IOException iOException) {}
    }

    public void run() {
        while (this.anim == Thread.currentThread()) {
            try {
                Socket s = this.ss.accept();
                GameSocket gs = new GameSocket(this, s);
                this.games.addElement(gs);
                this.gf.setPlayerCount(this.games.size());
            }
            catch (IOException iOException) {}
        }
    }

    public void gotLine(String line) {
        Enumeration e = this.games.elements();
        while (e.hasMoreElements()) {
            GameSocket gs = (GameSocket)e.nextElement();
            gs.print(line);
        }
    }

    public void disconnected(GameSocket gs) {
        this.games.removeElement(gs);
        this.gf.setPlayerCount(this.games.size());
    }

    public static void main(String[] args) {
        if (args.length == 4) {
            new GameServer(args[0], args[1], Integer.parseInt(args[2]), Integer.parseInt(args[3]));
        } else {
            new GameServer("Sample", "This is just Mike's test for GameFinder", 7566, 2);
        }
    }
}

