/*
 * Decompiled with CFR 0.152.
 */
package breakout;

import gamefinder.GameFinder;
import gamefinder.GameLocation;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class BOClient
implements Runnable {
    private Socket s;
    private DataInputStream dis;
    private DataOutputStream dos;
    private Thread runner;

    public BOClient() {
        GameLocation gameLocation = GameFinder.findGame();
        try {
            this.s = new Socket(gameLocation.getAddress(), gameLocation.getPort());
            this.dos = new DataOutputStream(this.s.getOutputStream());
            this.dis = new DataInputStream(this.s.getInputStream());
            this.runner = new Thread(this);
            this.runner.start();
        }
        catch (IOException iOException) {
            System.out.println("I caught an IOException in BOClient constructor");
        }
    }

    public void run() {
    }

    public int read() {
        int n = 0;
        try {
            n = this.dis.readInt();
        }
        catch (IOException iOException) {
            System.out.println("I caught an IOException BOClient read");
        }
        return n;
    }

    public int readTag() {
        int n = 0;
        try {
            n = this.dis.readInt();
        }
        catch (IOException iOException) {
            System.out.println("IOException BOClient readTag");
        }
        return n;
    }

    public long readTime() {
        long l = 0L;
        try {
            l = this.dis.readLong();
        }
        catch (IOException iOException) {
            System.out.println("IOException in BOClient readTime");
        }
        return l;
    }

    public double readVel() {
        double d = 0.0;
        try {
            d = this.dis.readDouble();
        }
        catch (IOException iOException) {
            System.out.println("IOException in BOClient readVel");
        }
        return d;
    }

    public int available() {
        try {
            return this.dis.available();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public void send(int n) {
        try {
            this.dos.writeInt(n);
            this.dos.flush();
        }
        catch (IOException iOException) {
            System.out.println("I caught an IOException: Client send(int)");
        }
    }

    public void send(double d) {
        try {
            this.dos.writeDouble(d);
            this.dos.flush();
        }
        catch (IOException iOException) {
            System.out.println("IOException: Client send(double)");
        }
    }

    public void sendCoords(int n, int n2) {
        try {
            this.dos.writeInt(n);
            this.dos.writeInt(n2);
            this.dos.flush();
        }
        catch (IOException iOException) {
            System.out.println("I caught an IOException in BOClient sendCoords");
        }
    }

    public void sendVel(double d, double d2) {
        try {
            this.dos.writeDouble(d);
            this.dos.writeDouble(d2);
            this.dos.flush();
        }
        catch (IOException iOException) {
            System.out.println("I caught an IOException: ClientHandler sendVel");
        }
    }

    public void cleanUp() {
        try {
            this.dos.flush();
        }
        catch (IOException iOException) {}
    }
}

