/*
 * Decompiled with CFR 0.152.
 */
package breakout;

import breakout.ClientHandler;
import gamefinder.GameFinder;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

public class BOServer
implements Runnable {
    private Vector clientHandlers;
    private ServerSocket ss;
    private Thread runner;
    public int currentPlayerCount = 0;
    private GameFinder gf;

    public BOServer() {
        try {
            this.ss = new ServerSocket(4321);
            System.out.println("Creating new ServerSocket on port 4321");
        }
        catch (IOException iOException) {
            System.out.println("I caught an IOException in BOServer constructor" + iOException);
        }
        this.gf = GameFinder.announce((String)"Breakout!", (String)"Not your ordinary game of bricks...", (int)4321, (int)2);
        this.clientHandlers = new Vector();
        this.runner = new Thread(this);
        this.runner.start();
    }

    public void run() {
        int n = 1;
        while (n < 3) {
            try {
                Socket socket = this.ss.accept();
                System.out.println("Creating Socket to listen on" + socket);
                if (socket != null) {
                    ClientHandler clientHandler = new ClientHandler(socket, this);
                    System.out.println("Created new ClientHandler");
                    this.clientHandlers.addElement(clientHandler);
                    ++this.currentPlayerCount;
                    if (this.currentPlayerCount == 2) {
                        this.writeOneInt(this.currentPlayerCount, clientHandler);
                        System.out.println("Server wrote currentPlayerCount " + this.currentPlayerCount);
                    }
                }
            }
            catch (IOException iOException) {
                System.out.println("I caught an IOException in BOServer run");
            }
            this.gf.setPlayerCount(this.currentPlayerCount);
            ++n;
        }
    }

    public synchronized void sendDoublesToAllExcept(double d, double d2, ClientHandler clientHandler) {
        int n = this.clientHandlers.size();
        int n2 = 0;
        while (n2 < n) {
            ClientHandler clientHandler2 = (ClientHandler)this.clientHandlers.elementAt(n2);
            if (clientHandler2 != clientHandler) {
                clientHandler2.sendVel(d, d2);
                System.out.println("Server sending velocities");
            }
            ++n2;
        }
    }

    public synchronized void writeToAllExcept(int n, int n2, ClientHandler clientHandler) {
        int n3 = this.clientHandlers.size();
        int n4 = 0;
        while (n4 < n3) {
            ClientHandler clientHandler2 = (ClientHandler)this.clientHandlers.elementAt(n4);
            if (clientHandler2 != clientHandler) {
                clientHandler2.sendCoords(n, n2);
                System.out.println("Server sending coordinates");
            }
            ++n4;
        }
    }

    public synchronized void writeOneInt(int n, ClientHandler clientHandler) {
        clientHandler.send(n);
        System.out.println("Server sending one int");
    }

    public synchronized void writeOne(int n, ClientHandler clientHandler) {
        int n2 = this.clientHandlers.size();
        int n3 = 0;
        while (n3 < n2) {
            ClientHandler clientHandler2 = (ClientHandler)this.clientHandlers.elementAt(n3);
            if (clientHandler2 != clientHandler) {
                clientHandler2.send(n);
                System.out.println("Server sending one");
            }
            ++n3;
        }
    }

    public synchronized void sendTime(long l) {
        int n = this.clientHandlers.size();
        int n2 = 0;
        while (n2 < n) {
            ClientHandler clientHandler = (ClientHandler)this.clientHandlers.elementAt(n2);
            clientHandler.sendTime(l);
            System.out.println("Server sending time");
            ++n2;
        }
    }

    public void writePlayers(int n) {
        int n2 = this.clientHandlers.size();
        int n3 = 0;
        while (n3 < n2) {
            ClientHandler clientHandler = (ClientHandler)this.clientHandlers.elementAt(n3);
            clientHandler.writePlayers(n);
            System.out.println("Server sending number of players");
            ++n3;
        }
    }

    public void removeClientHandler(ClientHandler clientHandler) {
        this.clientHandlers.removeElement(clientHandler);
    }
}

