/*
 * Decompiled with CFR 0.152.
 */
package breakout;

import breakout.BreakOutBall;
import breakout.BrickRepository;
import breakout.ClassicBall;
import breakout.GhostBall;
import breakout.ScreenCanvas;
import breakout.Updater;
import java.awt.Graphics;
import java.util.Vector;

public class BallRepository {
    private ScreenCanvas screen;
    private BrickRepository brickrepos;
    public Vector ballvect;
    private int playerCount;
    public int numberOfMyBalls = 0;
    public int numberOfGhostBalls = 0;
    public Updater updates;

    public BallRepository(ScreenCanvas screenCanvas, BrickRepository brickRepository) {
        this.screen = screenCanvas;
        this.updates = new Updater(this.screen);
        this.brickrepos = brickRepository;
        this.ballvect = new Vector();
    }

    public void makeInitialBall() {
        double d = -((Math.random() + 1.0) * 3.0);
        double d2 = -((Math.random() + 1.0) * 3.0);
        int n = (this.screen.xMin + this.screen.xMax) / 2;
        int n2 = this.screen.yMax - 32;
        ClassicBall classicBall = new ClassicBall(this.screen, this.brickrepos, this, n, n2, d, d2, 10004);
        this.addBall(classicBall);
    }

    public void makeMultiBalls(ClassicBall classicBall) {
        int n = 1;
        while (n < 3) {
            double d = -classicBall.xVel * (Math.random() + 1.0);
            double d2 = -classicBall.yVel * (Math.random() + 1.0);
            ClassicBall classicBall2 = new ClassicBall(this.screen, this.brickrepos, this, classicBall.center.x, classicBall.center.y, d, d2, 10005);
            this.addBall(classicBall2);
            ++n;
        }
    }

    public void makeGhostBall(int n, int n2) {
        GhostBall ghostBall = new GhostBall(this.screen, this.brickrepos, this, n, n2, 10004);
        System.out.println("text2" + this.updates);
        this.addBall(ghostBall);
    }

    public void addBall(BreakOutBall breakOutBall) {
        this.ballvect.addElement(breakOutBall);
        System.out.println("added ball to vector");
    }

    public void deleteBall(BreakOutBall breakOutBall) {
        try {
            boolean bl = this.ballvect.removeElement(breakOutBall);
            this.screen.repaint();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("Invalid index for adding brick to repository");
        }
    }

    public void paintBalls(Graphics graphics) {
        int n = 0;
        n = 0;
        while (n < this.ballvect.size()) {
            BreakOutBall breakOutBall = (BreakOutBall)this.ballvect.get(n);
            if (this.screen.playerID == 1) {
                if (breakOutBall instanceof GhostBall) {
                    ((GhostBall)breakOutBall).paintGhostBall(graphics);
                }
                if (breakOutBall instanceof ClassicBall) {
                    ((ClassicBall)breakOutBall).paintClassicBall(graphics);
                }
            } else if (this.screen.playerID == 2) {
                if (breakOutBall instanceof ClassicBall) {
                    ((ClassicBall)breakOutBall).paintClassicBall(graphics);
                }
                if (breakOutBall instanceof GhostBall) {
                    ((GhostBall)breakOutBall).paintGhostBall(graphics);
                }
            }
            ++n;
        }
    }
}

