/*
 * Decompiled with CFR 0.152.
 */
package breakout;

import breakout.BreakOutBall;
import breakout.BreakOutBrick;
import breakout.Brick100;
import breakout.ClassicBall;
import breakout.DudBrick;
import breakout.GhostBall;
import breakout.ScreenCanvas;
import breakout.StationaryBrick;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.Vector;

public class BrickRepository {
    private ScreenCanvas screen;
    private Vector brickvect;
    private Dimension scDim;
    private int scHeight;
    private int scWidth;
    private int vectSize;

    public BrickRepository(ScreenCanvas screenCanvas) {
        this.screen = screenCanvas;
        this.brickvect = new Vector();
        this.scDim = screenCanvas.getSize();
        this.scHeight = (int)this.scDim.getHeight();
        this.scWidth = (int)this.scDim.getWidth();
    }

    public void makeBricks() {
        StationaryBrick stationaryBrick;
        Point point = new Point(0, 0);
        Point point2 = new Point(0, 0);
        int n = 75;
        int n2 = 0;
        while (n < this.screen.xMax - 50) {
            point.setLocation(n, 50);
            point2.setLocation(n += 50, 65);
            stationaryBrick = new StationaryBrick(this.screen, this, point, point2);
            this.addBrick(stationaryBrick, n2);
            ++n2;
        }
        n = 50;
        n2 = this.vectSize;
        while (n < this.screen.xMax - 50) {
            point.setLocation(n, 65);
            point2.setLocation(n += 50, 80);
            stationaryBrick = new Brick100(this.screen, this, point, point2);
            this.addBrick(stationaryBrick, n2);
            ++n2;
        }
        n = 75;
        n2 = this.vectSize;
        while (n < this.screen.xMax - 50) {
            point.setLocation(n, 80);
            point2.setLocation(n += 50, 95);
            stationaryBrick = new Brick100(this.screen, this, point, point2);
            this.addBrick(stationaryBrick, n2);
            ++n2;
        }
        n = 100;
        n2 = this.vectSize;
        while (n < this.screen.xMax - 100) {
            point.setLocation(n, 95);
            point2.setLocation(n += 50, 110);
            stationaryBrick = new Brick100(this.screen, this, point, point2);
            this.addBrick(stationaryBrick, n2);
            ++n2;
        }
        n = 125;
        n2 = this.vectSize;
        while (n < this.screen.xMax - 125) {
            point.setLocation(n, 110);
            point2.setLocation(n += 50, 125);
            stationaryBrick = new Brick100(this.screen, this, point, point2);
            this.addBrick(stationaryBrick, n2);
            ++n2;
        }
    }

    public void addBrick(BreakOutBrick breakOutBrick, int n) {
        this.brickvect.add(n, breakOutBrick);
        ++this.vectSize;
        if (breakOutBrick instanceof Brick100) {
            ++this.screen.numberOfBrick100s;
        }
    }

    public void deleteBrick(BreakOutBrick breakOutBrick, int n) {
        try {
            this.brickvect.setElementAt(breakOutBrick, n);
            System.out.println(this.screen.numberOfBrick100s);
            if (breakOutBrick instanceof Brick100) {
                --this.screen.numberOfBrick100s;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("Invalid index for adding brick to repository");
        }
    }

    public void checkHitBrick(BreakOutBall breakOutBall) {
        this.vectSize = this.brickvect.size();
        Point point = new Point(breakOutBall.getCenter());
        double d = breakOutBall.getRadius();
        double d2 = breakOutBall.getXvelocity();
        double d3 = breakOutBall.getYvelocity();
        int n = 0;
        while (n < this.vectSize) {
            BreakOutBrick breakOutBrick = (BreakOutBrick)this.brickvect.get(n);
            Point point2 = new Point(breakOutBrick.getUpperLft());
            Point point3 = new Point(breakOutBrick.getLowerRt());
            if ((double)point.x + d >= (double)point2.x && (double)point.x - d <= (double)point3.x && (double)point.y + d >= (double)point2.y && (double)point.y - d <= (double)point3.y) {
                if (breakOutBrick instanceof Brick100) {
                    if ((double)point.x + d >= (double)point3.x) {
                        breakOutBall.changeXvelocity(Math.abs(d2));
                    }
                    if ((double)point.x - d <= (double)point2.x) {
                        breakOutBall.changeXvelocity(-Math.abs(d2));
                    }
                    if ((double)point.y + d >= (double)point3.y) {
                        breakOutBall.changeYvelocity(Math.abs(d3));
                    }
                    if ((double)point.y - d <= (double)point2.y) {
                        breakOutBall.changeYvelocity(-Math.abs(d3));
                    }
                    this.screen.myScore += 100;
                    Toolkit.getDefaultToolkit().beep();
                    DudBrick dudBrick = new DudBrick(breakOutBrick.getCanvas(), breakOutBrick.getBrickRepos(), breakOutBrick.getUpperLft(), breakOutBrick.getLowerRt());
                    this.deleteBrick(dudBrick, n);
                    if (((Brick100)breakOutBrick).multiBrickTag > 0.9 && breakOutBall instanceof ClassicBall) {
                        this.screen.ballrepos.makeMultiBalls((ClassicBall)breakOutBall);
                    }
                } else if (breakOutBrick instanceof StationaryBrick) {
                    if ((double)point.x + d >= (double)point3.x) {
                        breakOutBall.changeXvelocity(Math.abs(d2));
                    }
                    if ((double)point.x - d <= (double)point2.x) {
                        breakOutBall.changeXvelocity(-Math.abs(d2));
                    }
                    if ((double)point.y + d >= (double)point3.y) {
                        breakOutBall.changeYvelocity(Math.abs(d3));
                    }
                    if ((double)point.y - d <= (double)point2.y) {
                        breakOutBall.changeYvelocity(-Math.abs(d3));
                    }
                }
            }
            ++n;
        }
    }

    public void checkGhostHit(GhostBall ghostBall) {
        this.vectSize = this.brickvect.size();
        Point point = new Point(ghostBall.getCenter());
        double d = ghostBall.getRadius();
        int n = 0;
        while (n < this.vectSize) {
            BreakOutBrick breakOutBrick = (BreakOutBrick)this.brickvect.get(n);
            Point point2 = new Point(breakOutBrick.getUpperLft());
            Point point3 = new Point(breakOutBrick.getLowerRt());
            if ((double)point.x + d >= (double)point2.x && (double)point.x - d <= (double)point3.x && (double)point.y + d >= (double)point2.y && (double)point.y - d <= (double)point3.y && breakOutBrick instanceof Brick100) {
                StationaryBrick stationaryBrick = new StationaryBrick(breakOutBrick.getCanvas(), breakOutBrick.getBrickRepos(), breakOutBrick.getUpperLft(), breakOutBrick.getLowerRt());
                System.out.println("going to convert to stat brick");
                this.deleteBrick(stationaryBrick, n);
            }
            ++n;
        }
    }

    public void paintBricks(Graphics graphics) {
        int n = 0;
        while (n < this.vectSize) {
            int n2;
            int n3;
            int n4;
            int n5;
            BreakOutBrick breakOutBrick = (BreakOutBrick)this.brickvect.get(n);
            if (breakOutBrick instanceof StationaryBrick) {
                n5 = breakOutBrick.getUpperLft().x;
                n4 = breakOutBrick.getUpperLft().y;
                n3 = breakOutBrick.getLowerRt().x - breakOutBrick.getUpperLft().x;
                n2 = breakOutBrick.getLowerRt().y - breakOutBrick.getUpperLft().y;
                graphics.setColor(Color.gray);
                graphics.fill3DRect(n5, n4, n3, n2, true);
            }
            if (breakOutBrick instanceof Brick100) {
                n5 = breakOutBrick.getUpperLft().x;
                n4 = breakOutBrick.getUpperLft().y;
                n3 = breakOutBrick.getLowerRt().x - breakOutBrick.getUpperLft().x;
                n2 = breakOutBrick.getLowerRt().y - breakOutBrick.getUpperLft().y;
                graphics.setColor(Color.orange);
                graphics.fill3DRect(n5, n4, n3, n2, true);
            }
            ++n;
        }
    }
}

