/*
 * Decompiled with CFR 0.152.
 */
package breakout;

import breakout.BallRepository;
import breakout.BreakOutBall;
import breakout.BrickRepository;
import breakout.ScreenCanvas;
import cs101.lang.Animate;
import cs101.lang.AnimatorThread;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class ClassicBall
implements BreakOutBall,
Animate {
    ScreenCanvas screen;
    BrickRepository brickrepos;
    BallRepository ballrepos;
    Point center = new Point(0, 0);
    public double radius = 6.0;
    public double xVel;
    public double yVel;
    private AnimatorThread anim;
    public int ballType;

    public ClassicBall(ScreenCanvas screenCanvas, BrickRepository brickRepository, BallRepository ballRepository, int n, int n2, double d, double d2, int n3) {
        this.screen = screenCanvas;
        this.brickrepos = brickRepository;
        this.ballrepos = ballRepository;
        this.xVel = d;
        this.yVel = d2;
        this.ballType = n3;
        this.center.x = n;
        this.center.y = n2;
        this.anim = new AnimatorThread((Animate)this, 0L, 10L);
        this.anim.startExecution();
    }

    public Point getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getXvelocity() {
        return this.xVel;
    }

    public double getYvelocity() {
        return this.yVel;
    }

    public void changeXvelocity(double d) {
        this.xVel = d;
    }

    public void changeYvelocity(double d) {
        this.yVel = d;
    }

    public void paintClassicBall(Graphics graphics) {
        double d = this.center.getX() - this.radius;
        double d2 = this.center.getY() - this.radius;
        if (this.ballType == 10004) {
            this.screen.connection.send(this.center.x);
            this.screen.connection.send(this.center.y);
        }
        graphics.setColor(Color.red.brighter());
        graphics.fillOval((int)d, (int)d2, (int)(2.0 * this.radius), (int)(2.0 * this.radius));
    }

    public void act() {
        if (!this.screen.getPause()) {
            if ((double)this.center.x + this.radius >= (double)this.screen.xMax) {
                this.xVel = -Math.abs(this.xVel);
            } else if ((double)this.center.x - this.radius <= (double)this.screen.getMinX()) {
                this.xVel = Math.abs(this.xVel);
            } else if ((double)this.center.y + this.radius >= (double)this.screen.getMaxY()) {
                if (this.ballType == 10005) {
                    this.ballrepos.deleteBall(this);
                } else {
                    long l = 800L;
                    try {
                        this.center.x = (this.screen.CanvasPaddleUL.x + this.screen.CanvasPaddleLR.x) / 2;
                        this.center.y = this.screen.yMax - 32;
                        this.screen.repaint();
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println("Exception occurred..in sleep method");
                    }
                    this.yVel = -Math.abs(this.yVel);
                }
            } else if ((double)this.center.y - this.radius <= (double)this.screen.getMinY()) {
                this.yVel = Math.abs(this.yVel);
            } else if ((double)this.center.y - this.radius < 140.0) {
                this.brickrepos.checkHitBrick(this);
            } else if ((double)this.center.y + this.radius > 460.0) {
                this.screen.checkHitPaddle(this);
            }
            this.center.x = (int)((double)this.center.x + this.xVel);
            this.center.y = (int)((double)this.center.y + this.yVel);
            this.screen.repaint();
            return;
        }
    }
}

