/*
 * Decompiled with CFR 0.152.
 */
package breakout;

import breakout.BOServer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class ClientHandler
implements Runnable {
    private BOServer server;
    private Socket client;
    private DataInputStream dis;
    private DataOutputStream dos;
    private Thread runner;
    private int currentPlayerCount;
    private long time = 0L;
    private boolean clientQuit;

    public ClientHandler(Socket socket, BOServer bOServer) {
        this.server = bOServer;
        this.client = socket;
        try {
            this.dis = new DataInputStream(this.client.getInputStream());
            this.dos = new DataOutputStream(this.client.getOutputStream());
            this.currentPlayerCount = this.server.currentPlayerCount;
        }
        catch (IOException iOException) {
            System.out.println("I caught an IOException in ClientHandler constructor");
        }
        this.runner = new Thread(this);
        this.runner.start();
    }

    public void run() {
        if (this.currentPlayerCount == 1) {
            this.server.writeOne(this.currentPlayerCount, this);
        }
        while (true) {
            try {
                while (true) {
                    int n = this.dis.readInt();
                    int n2 = this.dis.readInt();
                    this.server.writeToAllExcept(n, n2, this);
                }
            }
            catch (IOException iOException) {
                System.out.println("I caught an IOException ClientHandler run");
                continue;
            }
            break;
        }
    }

    public void send(int n) {
        try {
            this.dos.writeInt(n);
            this.dos.flush();
        }
        catch (IOException iOException) {
            System.out.println("I caught an IOException: ClientHandler write");
        }
    }

    public void sendCoords(int n, int n2) {
        try {
            this.dos.writeInt(n);
            this.dos.writeInt(n2);
            this.dos.flush();
            System.out.println("Sending coordinates in CH");
        }
        catch (IOException iOException) {
            System.out.println("I caught an IOException ClientHandler sendCoords");
        }
    }

    public void sendVel(double d, double d2) {
        try {
            this.dos.writeDouble(d);
            this.dos.writeDouble(d2);
            this.dos.flush();
            System.out.println("Sending velocities in CH");
        }
        catch (IOException iOException) {
            System.out.println("I caught an IOException: ClientHandler sendVel");
        }
    }

    public void sendTime(long l) {
        try {
            this.dos.writeLong(l);
            this.dos.flush();
            System.out.println("Sending time in CH");
        }
        catch (IOException iOException) {
            System.out.println("IOException: ClientHandler sendTime");
        }
    }

    public void writePlayers(int n) {
        try {
            this.dos.writeInt(n);
            this.dos.flush();
            System.out.println("Sending currentPlayerCount in CH");
        }
        catch (IOException iOException) {
            System.out.println("I caught an IOException: CH writePlayers");
        }
    }

    public int read() {
        int n = 0;
        try {
            n = this.dis.readInt();
        }
        catch (IOException iOException) {
            System.out.println("IOException ClientHandler read");
        }
        return n;
    }

    public boolean readQuit() {
        boolean bl = false;
        try {
            bl = this.dis.readBoolean();
        }
        catch (IOException iOException) {
            System.out.println("IOException: CH readQuit()");
        }
        return bl;
    }
}

