/*
 * Decompiled with CFR 0.152.
 */
package breakout;

import breakout.BOClient;
import breakout.BallRepository;
import breakout.BreakOutBall;
import breakout.BrickRepository;
import breakout.ClassicBall;
import breakout.GhostBall;
import breakout.KeyboardListener;
import breakout.MouseTracker;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;

public class ScreenCanvas
extends Canvas {
    public BrickRepository brickrepos;
    public BallRepository ballrepos;
    public int xMin = 20;
    public int xMax = 700;
    public int yMin = 10;
    public int yMax = 600;
    public Point CanvasPaddleUL = new Point((this.xMin + this.xMax) / 2 - 40, this.yMax - 25);
    public Point CanvasPaddleLR = new Point((this.xMin + this.xMax) / 2 + 40, this.yMax - 15);
    public Dimension offDimension;
    public Image offImage;
    public Graphics offGraphics;
    public boolean pause = true;
    public int myScore = 0;
    public int otherScore = 0;
    public int numberOfBrick100s = 0;
    public boolean changeX = false;
    public boolean changeY = false;
    public String myScoreString = "YOUR SCORE =  ";
    public String otherScoreString = "OPPONENT's SCORE =  ";
    private int tempXpos;
    private int tempYpos;
    public int numberOfPlayers = 0;
    public int playerID;
    public int ghostX;
    public int ghostY;
    public BOClient connection = new BOClient();

    public ScreenCanvas() {
        System.out.println("About to read from new connection.");
        System.out.println("Available bytes: " + this.connection.available());
        this.playerID = this.connection.read();
        System.out.println("player id =  " + this.playerID);
        this.setSize(this.xMax, this.yMax - 10);
        this.setBackground(Color.black);
        KeyboardListener keyboardListener = new KeyboardListener(this);
        this.addKeyListener(keyboardListener);
        MouseTracker mouseTracker = new MouseTracker(this);
        this.addMouseMotionListener(mouseTracker);
        this.brickrepos = new BrickRepository(this);
        this.ballrepos = new BallRepository(this, this.brickrepos);
        this.brickrepos.makeBricks();
        this.ballrepos.makeInitialBall();
        int n = (this.xMin + this.xMax + 30) / 2;
        int n2 = this.yMax - 62;
        this.ballrepos.makeGhostBall(n, n2);
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.size();
        if (this.offGraphics == null || dimension.width != this.offDimension.width || dimension.height != this.offDimension.height) {
            this.offDimension = dimension;
            this.offImage = this.createImage(dimension.width, dimension.height);
            this.offGraphics = this.offImage.getGraphics();
        }
        this.offGraphics.setColor(this.getBackground());
        this.offGraphics.fillRect(0, 0, dimension.width, dimension.height);
        this.offGraphics.setColor(Color.black);
        this.paintFrame(this.offGraphics);
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.offImage != null) {
            graphics.drawImage(this.offImage, 0, 0, null);
        } else {
            this.update(graphics);
        }
    }

    public void paintFrame(Graphics graphics) {
        this.brickrepos.paintBricks(graphics);
        this.paintPaddle(graphics);
        this.paintScores(graphics);
        this.ballrepos.paintBalls(graphics);
    }

    public void paintPaddle(Graphics graphics) {
        graphics.setColor(Color.green);
        graphics.drawRect(this.xMin - 1, this.yMin - 1, this.xMax - this.xMin + 2, this.yMax - this.yMin + 2);
        graphics.setColor(Color.blue);
        graphics.fillRect(this.CanvasPaddleUL.x, this.CanvasPaddleUL.y, 81, 10);
    }

    public void paintScores(Graphics graphics) {
        graphics.setColor(Color.white.brighter());
        graphics.drawString(String.valueOf(this.myScoreString) + this.myScore, this.xMin, this.yMax + 20);
    }

    public void showStuff() {
        this.repaint();
    }

    public void checkHitPaddle(ClassicBall classicBall) {
        Point point = new Point(classicBall.getCenter());
        double d = classicBall.getRadius();
        if ((double)point.x + d >= (double)this.CanvasPaddleUL.x && (double)point.x - d <= (double)this.CanvasPaddleLR.x && (double)point.y + d >= (double)this.CanvasPaddleUL.y && (double)point.y - d <= (double)this.CanvasPaddleLR.y) {
            classicBall.yVel = -Math.abs(classicBall.yVel);
        }
    }

    public void mouseMovePaddle(int n, int n2) {
        if (!this.pause) {
            this.CanvasPaddleUL.x = n - 39;
            this.CanvasPaddleLR.x = n + 39;
            this.repaint();
        }
    }

    public void updateLeft() {
        if (!this.pause) {
            if (this.CanvasPaddleUL.x >= this.xMin + 10) {
                this.CanvasPaddleUL.x -= 10;
                this.CanvasPaddleLR.x -= 10;
                this.repaint();
            } else {
                int n = this.CanvasPaddleUL.x - this.xMin;
                this.CanvasPaddleUL.x -= n;
                this.CanvasPaddleLR.x -= n;
                this.repaint();
            }
        }
    }

    public void updateRight() {
        if (!this.pause) {
            if (this.CanvasPaddleLR.x <= this.xMax - 10) {
                this.CanvasPaddleUL.x += 10;
                this.CanvasPaddleLR.x += 10;
                this.repaint();
            } else {
                int n = this.xMax - this.CanvasPaddleLR.x;
                this.CanvasPaddleUL.x += n - 2;
                this.CanvasPaddleLR.x += n - 2;
                this.repaint();
            }
        }
    }

    public boolean getPause() {
        return this.pause;
    }

    public int getMaxX() {
        return this.xMax;
    }

    public int getMinX() {
        return this.xMin;
    }

    public int getMaxY() {
        return this.yMax;
    }

    public int getMinY() {
        return this.yMin;
    }

    public void pressAction(int n, int n2) {
        this.tempXpos = n;
        this.tempYpos = n2;
        this.repaint();
    }

    public void updatePlayers() {
        this.ghostX = this.connection.read();
        this.ghostY = this.connection.read();
        this.updatingGhostBall(this.ghostX, this.ghostY);
    }

    public void updatingGhostBall(int n, int n2) {
        int n3 = this.ballrepos.ballvect.size();
        this.ghostX = n;
        this.ghostY = n2;
        int n4 = 0;
        while (n4 < n3) {
            BreakOutBall breakOutBall = (BreakOutBall)this.ballrepos.ballvect.elementAt(n4);
            if (breakOutBall instanceof GhostBall) {
                ((GhostBall)breakOutBall).changeCenter(n, n2);
            }
            ++n4;
        }
    }
}

