/*
 * Decompiled with CFR 0.152.
 */
package cs101.awt;

import cs101.awt.GameControllable;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class DefaultGameFrame
extends Frame {
    protected Component c;
    protected GameControllable gc;
    private Dimension defaultDimension = new Dimension(500, 400);

    public DefaultGameFrame(GameControllable gameControllable) {
        this(gameControllable, gameControllable instanceof Component ? (Component)((Object)gameControllable) : null);
    }

    public DefaultGameFrame(GameControllable gameControllable, Component component) {
        this(gameControllable, component, new Dimension(500, 400));
    }

    public DefaultGameFrame(GameControllable gameControllable, Component component, int n, int n2) {
        this(gameControllable, component, new Dimension(n, n2));
    }

    public DefaultGameFrame(GameControllable gameControllable, Component component, Dimension dimension) {
        super("GameFrame");
        this.c = component;
        this.gc = gameControllable;
        this.defaultDimension = dimension;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DefaultGameFrame.this.shutdown();
            }
        });
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("gameControl", true);
        menu.add(this.createMenuItem("Start...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultGameFrame.this.gc.start();
            }
        }));
        menu.add(this.createMenuItem("Stop....", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultGameFrame.this.gc.stop();
            }
        }));
        menu.add(this.createMenuItem("Reset...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultGameFrame.this.gc.reset();
            }
        }));
        menu.add(this.createCheckboxMenuItem("Pause...", new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)itemEvent.getSource();
                if (checkboxMenuItem.getState()) {
                    DefaultGameFrame.this.gc.pause();
                } else {
                    DefaultGameFrame.this.gc.unpause();
                }
            }
        }));
        menu.addSeparator();
        menu.add(this.createMenuItem("Quit....", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultGameFrame.this.shutdown();
            }
        }));
        menuBar.add(menu);
        this.setMenuBar(menuBar);
        this.pack();
    }

    private final CheckboxMenuItem createCheckboxMenuItem(String string, ItemListener itemListener) {
        CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(string);
        checkboxMenuItem.addItemListener(itemListener);
        return checkboxMenuItem;
    }

    private final MenuItem createMenuItem(String string, ActionListener actionListener) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.addActionListener(actionListener);
        return menuItem;
    }

    public Dimension getPreferredSize() {
        return this.defaultDimension;
    }

    public void init() {
        this.add("Center", this.c);
        this.show();
    }

    protected void shutdown() {
        this.dispose();
        System.exit(0);
    }
}

