/*
 * Decompiled with CFR 0.152.
 */
package cs101.awt;

import java.awt.Color;
import java.awt.Graphics;
import java.util.StringTokenizer;

public class Line {
    private Color c;
    private int startX;
    private int startY;
    private int endX;
    private int endY;
    public static final Color DEFAULT_COLOR = Color.black;

    private Line() {
    }

    public Line(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, DEFAULT_COLOR);
    }

    public Line(int n, int n2, int n3, int n4, Color color) {
        this.startX = n;
        this.startY = n2;
        this.endX = n3;
        this.endY = n4;
        this.c = color == null ? DEFAULT_COLOR : color;
    }

    public void drawOn(Graphics graphics) {
        graphics.setColor(this.c);
        graphics.drawLine(this.startX, this.startY, this.endX, this.endY);
    }

    public static Line extractLine(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n:");
        Line line = new Line();
        line.startX = Integer.parseInt(stringTokenizer.nextToken());
        line.startY = Integer.parseInt(stringTokenizer.nextToken());
        line.endX = Integer.parseInt(stringTokenizer.nextToken());
        line.endY = Integer.parseInt(stringTokenizer.nextToken());
        line.c = stringTokenizer.hasMoreTokens() ? new Color(Integer.parseInt(stringTokenizer.nextToken())) : DEFAULT_COLOR;
        return line;
    }

    public static String packLine(Line line) {
        return String.valueOf(Integer.toString(line.startX)) + ":" + Integer.toString(line.startY) + ":" + Integer.toString(line.endX) + ":" + Integer.toString(line.endY) + ":" + Integer.toString(line.c.getRGB()) + "\n";
    }
}

