/*
 * Decompiled with CFR 0.152.
 */
package cs101.net;

import cs101.net.Server;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;

public class BabySitter
implements Runnable {
    protected Server server;
    protected Thread spirit;
    protected Socket sock;
    protected ObjectInputStream ois;
    protected ObjectOutputStream oos;
    private boolean stopped;

    protected BabySitter(Socket socket, Server server) {
        System.out.println("Server:  setting up new connection from " + socket.getInetAddress().getHostName() + " on port " + socket.getPort());
        this.sock = socket;
        this.server = server;
        try {
            this.oos = new ObjectOutputStream(socket.getOutputStream());
            this.ois = new ObjectInputStream(socket.getInputStream());
        }
        catch (IOException iOException) {
            try {
                this.sock.close();
            }
            catch (IOException iOException2) {}
            System.out.println("Server:  socket error in BabySitter");
            this.server.removeBabySitter(this);
            return;
        }
        this.spirit = new Thread(this);
        this.spirit.start();
    }

    public void run() {
        System.out.println("Server:  BabySitter running");
        while (!this.stopped) {
            try {
                String string = (String)this.ois.readObject();
                System.out.println("Server:  just read '" + string + "' from " + this.sock.getInetAddress().getHostName() + ", port " + this.sock.getPort());
                if (string == null || string == "") {
                    this.server.removeBabySitter(this);
                    return;
                }
                this.server.sendToAllExcept(string, this);
            }
            catch (IOException iOException) {
                System.out.println("Server:  socket error in run ");
                this.server.removeBabySitter(this);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("Server:  could not find class String.");
                this.server.removeBabySitter(this);
            }
        }
    }

    protected void send(String string) {
        try {
            this.oos.writeObject(string);
        }
        catch (IOException iOException) {
            System.out.println("Server:  socket error in send");
            this.server.removeBabySitter(this);
        }
    }

    protected void stop() {
        System.out.println("Server:  closing connection from " + this.sock.getInetAddress().getHostName() + " on port " + this.sock.getPort());
        try {
            this.ois.close();
        }
        catch (IOException iOException) {}
        try {
            this.oos.close();
        }
        catch (IOException iOException) {}
        try {
            this.sock.close();
        }
        catch (IOException iOException) {}
        this.stopped = true;
    }
}

