/*
 * Decompiled with CFR 0.152.
 */
package cs101.net;

import cs101.awt.ServerDialog;
import cs101.net.BabySitter;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;

public class Server
implements Runnable {
    protected ServerSocket sock;
    protected Vector babySitters;
    protected Thread spirit;

    public Server() {
        ServerDialog serverDialog = new ServerDialog();
        serverDialog.ask();
        this.listenOn(serverDialog.getPort());
    }

    public Server(int n) {
        this.listenOn(n);
    }

    protected void listenOn(int n) {
        System.out.println("Server:  starting up on port " + n);
        try {
            this.sock = new ServerSocket(n);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Server:  failed to listen on port " + n);
        }
        this.babySitters = new Vector();
        this.spirit = new Thread(this);
        this.spirit.start();
    }

    protected void removeBabySitter(BabySitter babySitter) {
        this.babySitters.removeElement(babySitter);
        babySitter.stop();
    }

    public void run() {
        try {
            while (true) {
                System.out.println("Server:  listening for a connection");
                this.spawnBabySitter(this.sock.accept());
            }
        }
        catch (IOException iOException) {
            System.out.println("Server:  abrupt failure on accept attempt.");
            System.out.println("Server:  no longer accepting connections.");
            return;
        }
    }

    protected void sendToAllExcept(String string, BabySitter babySitter) {
        Enumeration enumeration = this.babySitters.elements();
        while (enumeration.hasMoreElements()) {
            BabySitter babySitter2 = (BabySitter)enumeration.nextElement();
            if (babySitter2 == babySitter) continue;
            babySitter2.send(string);
        }
    }

    protected void spawnBabySitter(Socket socket) {
        BabySitter babySitter = new BabySitter(socket, this);
        this.babySitters.addElement(babySitter);
    }
}

