/*
 * Decompiled with CFR 0.152.
 */
package cs101.net;

import cs101.net.AppletHostDialog;
import cs101.net.HostDialog;
import cs101.net.PortDialog;
import java.applet.Applet;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class SocketBroker {
    private Socket connect(InetAddress inetAddress, int n) {
        String string = inetAddress.getHostName();
        if (string == null) {
            string = "localhost";
        }
        System.out.println("Trying port " + n + " on host " + string + " ...");
        try {
            return new Socket(inetAddress, n);
        }
        catch (IOException iOException) {
            if (iOException.toString().equals("java.net.SocketException: Broken pipe")) {
                System.out.println("SocketBroker: Server not found at port " + n + " on host " + string + ".");
                System.out.println("Make sure server is running and try again.");
            } else {
                System.out.println("SocketBroker: Error durring connect: " + iOException);
            }
            return this.getConnection();
        }
    }

    private InetAddress getAddress() {
        boolean bl = false;
        InetAddress inetAddress = null;
        do {
            HostDialog hostDialog = new HostDialog(this);
            Object object = this;
            synchronized (object) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            object = hostDialog.answer;
            try {
                inetAddress = InetAddress.getByName((String)object);
            }
            catch (UnknownHostException unknownHostException) {
                System.out.println("SocketBroker: Invalid hostname " + (String)object);
                System.out.println(unknownHostException);
                bl = true;
            }
            hostDialog = null;
        } while (bl);
        return inetAddress;
    }

    public Socket getConnection() {
        InetAddress inetAddress = this.getAddress();
        int n = this.getPort();
        return this.connect(inetAddress, n);
    }

    public Socket getConnection(int n) {
        InetAddress inetAddress = this.getAddress();
        if (n <= 1024 && n > 9999) {
            System.out.println("SocketBroker: Invalid port number " + n + " received.");
            System.out.println("Port numbers must be between 1024 and 9999.");
            n = this.getPort();
        }
        return this.connect(inetAddress, n);
    }

    public Socket getConnection(Applet applet) {
        return this.getConnection(applet, "SERVER", "PORT");
    }

    public Socket getConnection(Applet applet, String string, String string2) {
        Object object;
        System.out.println("Checking for applet parameters " + string + " and " + string2 + " ...");
        String string3 = applet.getParameter(string);
        if (string3 == null) {
            object = new AppletHostDialog(this);
            SocketBroker socketBroker = this;
            synchronized (socketBroker) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (((AppletHostDialog)object).answer) {
                System.out.println("Using applet's web server as server host ...");
                string3 = applet.getDocumentBase().getHost();
            }
            object = null;
        }
        if ((object = applet.getParameter(string2)) != null) {
            int n = Integer.parseInt((String)object);
            if (string3 != null) {
                return this.getConnection(string3, n);
            }
            return this.getConnection(n);
        }
        if (string3 != null) {
            return this.getConnection(string3);
        }
        return this.getConnection();
    }

    public Socket getConnection(String string) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("SocketBroker: Invalid hostname " + string);
            System.out.println(unknownHostException);
            return this.getConnection();
        }
        int n = this.getPort();
        return this.connect(inetAddress, n);
    }

    public Socket getConnection(String string, int n) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("SocketBroker: Invalid hostname " + string);
            System.out.println(unknownHostException);
            return this.getConnection(n);
        }
        if (n <= 1024 && n > 9999) {
            System.out.println("SocketBroker: Invalid port number " + n + " received.");
            System.out.println("Port numbers must be between 1024 and 9999.");
            n = this.getPort();
        }
        return this.connect(inetAddress, n);
    }

    public Socket getConnection(InetAddress inetAddress) {
        int n = this.getPort();
        return this.connect(inetAddress, n);
    }

    private int getPort() {
        while (true) {
            PortDialog portDialog = new PortDialog(this);
            SocketBroker socketBroker = this;
            synchronized (socketBroker) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            int n = portDialog.port;
            portDialog.dispose();
            portDialog = null;
            if (n > 1024 && n <= 9999) {
                return n;
            }
            System.out.println("SocketBroker: Invalid port number " + n + " received.");
            System.out.println("Port numbers must be between 1024 and 9999.");
        }
    }
}

