/*
 * Decompiled with CFR 0.152.
 */
package gamefinder;

import gamefinder.GameLocation;
import gamefinder.Message;
import gamefinder.Player;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;

public class GameFinder
implements Runnable,
ActionListener,
ListSelectionListener {
    private Thread anim;
    private MulticastSocket mcs = new MulticastSocket(8634);
    public static final int PORT = 8634;
    public static final String groupName = "228.76.24.6";
    private InetAddress group = InetAddress.getByName("228.76.24.6");
    private JFrame frame;
    private String name = null;
    private GameLocation mygame = null;
    private GameLocation chosen = null;
    private DefaultListModel folks;
    private DefaultListModel gamelist;
    private JTextArea chat;
    private JTextField chatEntry;
    private JList people;
    private JList games;
    private JLabel description;
    Tickler tickler;

    private GameFinder() throws IOException {
        this.mcs.joinGroup(this.group);
        this.anim = new Thread(this);
        this.anim.start();
    }

    public void actionPerformed(ActionEvent evt) {
        String line = String.valueOf(this.name) + ": " + this.chatEntry.getText();
        Message m = new Message(1, line.getBytes());
        this.send(m);
        this.chatEntry.setText("");
    }

    private void close() {
        if (this.tickler != null) {
            this.tickler.stop();
        }
        Message m = this.mygame == null ? new Message(3, this.name.getBytes()) : new Message(4, this.mygame.name.getBytes());
        this.send(m);
        try {
            this.mcs.leaveGroup(this.group);
            this.mcs.close();
        }
        catch (IOException iOException) {}
        GameFinder gameFinder = this;
        synchronized (gameFinder) {
            this.notify();
        }
    }

    private GameLocation waitForAnswer() {
        GameFinder gameFinder = this;
        synchronized (gameFinder) {
            try {
                System.out.println("Waiting for user to select a game...");
                this.wait();
                System.out.println("Got it.");
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.chosen;
    }

    public void valueChanged(ListSelectionEvent evt) {
        int idx = this.games.getSelectedIndex();
        if (idx >= 0) {
            GameLocation gl = (GameLocation)this.gamelist.elementAt(idx);
            this.description.setText(String.valueOf(gl.toString()) + ": " + gl.desc);
        } else {
            this.description.setText(" ");
        }
    }

    private GameFinder(String name) throws IOException {
        this();
        this.name = name;
        this.frame = new JFrame("GameFinder");
        this.chat = new JTextArea("Welcome!", 16, 40);
        this.chat.setEditable(false);
        this.frame.getContentPane().setLayout(new BorderLayout());
        JScrollPane chatp = new JScrollPane(this.chat);
        this.chatEntry = new JTextField(40);
        this.chatEntry.addActionListener(this);
        this.frame.getContentPane().add((Component)this.chatEntry, "South");
        this.frame.setDefaultCloseOperation(2);
        this.frame.addWindowListener(new 1());
        this.folks = new DefaultListModel();
        this.people = new JList(this.folks);
        this.people.setPrototypeCellValue("Averylongname");
        JScrollPane peoplep = new JScrollPane(this.people);
        this.frame.getContentPane().add((Component)peoplep, "East");
        this.gamelist = new DefaultListModel();
        this.games = new JList(this.gamelist);
        this.games.addMouseListener(new 2());
        this.games.setPrototypeCellValue("Cat and mouse game 2/2");
        this.games.addListSelectionListener(this);
        JScrollPane gamep = new JScrollPane(this.games);
        this.frame.getContentPane().add((Component)gamep, "West");
        this.description = new JLabel(" ");
        this.frame.getContentPane().add((Component)this.description, "North");
        this.frame.getContentPane().add((Component)chatp, "Center");
        this.frame.pack();
        ((Component)this.frame).setVisible(true);
        this.tickler = new Tickler(5000 + (int)(Math.random() * 1000.0));
        this.sayHello();
    }

    private GameFinder(String name, String desc, int port, int max) throws IOException {
        this();
        this.mygame = new GameLocation(name, desc, null, port, 0, max);
        this.doHello();
    }

    public void selectGame(MouseEvent evt) {
        int idx = this.games.getSelectedIndex();
        GameLocation gl = null;
        if (idx >= 0) {
            gl = (GameLocation)this.gamelist.elementAt(idx);
            if (evt.getClickCount() == 2 && gl.count < gl.max) {
                this.chosen = gl;
                this.frame.dispose();
            }
        }
    }

    public void run() {
        byte[] data = new byte[1024];
        DatagramPacket dp = new DatagramPacket(data, data.length);
        block9: while (this.anim == Thread.currentThread()) {
            block10: while (true) {
                try {
                    dp.setLength(data.length);
                    this.mcs.receive(dp);
                    Message m = new Message(dp);
                    switch (m.getType()) {
                        case 5: {
                            this.doHello();
                            continue block9;
                        }
                        case 0: {
                            this.doAnnounce(m);
                            continue block9;
                        }
                        case 6: {
                            this.doWelcome(m);
                            continue block9;
                        }
                        case 3: {
                            this.doDrop(m);
                            continue block9;
                        }
                        case 1: {
                            this.doChat(m);
                            continue block9;
                        }
                        default: {
                            if (this.anim == Thread.currentThread()) continue block10;
                        }
                    }
                }
                catch (IOException iOException) {
                    break block9;
                }
                break;
            }
        }
    }

    private void send(Message m) {
        byte[] data = m.getData();
        DatagramPacket dp = new DatagramPacket(data, data.length, this.group, 8634);
        try {
            this.mcs.send(dp);
        }
        catch (IOException iOException) {}
    }

    private void sayHello() {
        Message m = new Message(5, this.name.getBytes());
        this.send(m);
    }

    private void doHello() {
        Message m;
        if (this.mygame != null) {
            m = new Message(0, (String.valueOf(this.mygame.name) + "\n" + this.mygame.desc + "\n" + this.mygame.port + "\n" + this.mygame.count + "\n" + this.mygame.max).getBytes());
        } else {
            this.tickler.reset();
            int i = 0;
            while (i < this.gamelist.size()) {
                GameLocation gl = (GameLocation)this.gamelist.elementAt(i);
                if (gl.mark() < 0) {
                    this.gamelist.removeElement(gl);
                    this.valueChanged(null);
                    --i;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.folks.size()) {
                Player p = (Player)this.folks.elementAt(i2);
                if (p.mark() < 0) {
                    this.folks.removeElement(p);
                    --i2;
                }
                ++i2;
            }
            m = new Message(6, this.name.getBytes());
        }
        this.send(m);
    }

    private Player findPlayer(String name) {
        Player p = null;
        Enumeration e = this.folks.elements();
        while (e.hasMoreElements()) {
            p = (Player)e.nextElement();
            if (!p.name.equals(name)) continue;
            return p;
        }
        return null;
    }

    private GameLocation findGame(InetAddress addr, int port) {
        GameLocation gl = null;
        Enumeration e = this.gamelist.elements();
        while (e.hasMoreElements()) {
            gl = (GameLocation)e.nextElement();
            if (!gl.addr.equals(addr) || gl.port != port) continue;
            return gl;
        }
        return null;
    }

    private void doWelcome(Message m) {
        if (this.folks == null) {
            return;
        }
        String name = new String(m.getData());
        Player p = this.findPlayer(name);
        if (p != null) {
            p.refresh();
        } else {
            p = new Player(m.getAddr(), new String(m.getData()));
            this.folks.addElement(p);
        }
    }

    private void doAnnounce(Message m) {
        if (this.folks == null) {
            return;
        }
        String info = new String(m.getData());
        int idx = info.indexOf("\n");
        int idx2 = info.indexOf("\n", idx + 1);
        int idx3 = info.indexOf("\n", idx2 + 1);
        int idx4 = info.indexOf("\n", idx3 + 1);
        if (idx < 0 || idx2 < 0 || idx3 < 0 || idx4 < 0) {
            return;
        }
        String name = info.substring(0, idx);
        String type = info.substring(idx + 1, idx2);
        int port = Integer.parseInt(info.substring(idx2 + 1, idx3));
        int count = Integer.parseInt(info.substring(idx3 + 1, idx4));
        int max = Integer.parseInt(info.substring(idx4 + 1));
        GameLocation gl = this.findGame(m.getAddr(), port);
        if (gl != null) {
            gl.refresh();
            gl.count = count;
            this.valueChanged(null);
            this.games.repaint();
        } else {
            gl = new GameLocation(name, type, m.getAddr(), port, count, max);
            this.gamelist.addElement(gl);
        }
    }

    private void doDrop(Message m) {
        if (this.folks == null) {
            return;
        }
        String name = new String(m.getData());
        Player p = this.findPlayer(name);
        if (p != null) {
            this.folks.removeElement(p);
        }
    }

    private void doChat(Message m) {
        block3: {
            if (this.folks == null) {
                return;
            }
            String message = new String(m.getData());
            JViewport jv = (JViewport)this.chat.getParent();
            boolean atBottom = jv.getViewPosition().y + jv.getExtentSize().height == this.chat.getSize().height;
            this.chat.append("\n" + message);
            if (!atBottom) break block3;
            try {
                this.chat.scrollRectToVisible(this.chat.modelToView(this.chat.getDocument().getLength()));
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public static GameLocation findGame() {
        String name = JOptionPane.showInputDialog("Username:");
        if (name == null) {
            return null;
        }
        return GameFinder.findGame(name);
    }

    public static GameLocation findGame(String name) {
        try {
            GameFinder gf = new GameFinder(name);
            return gf.waitForAnswer();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static GameFinder announce(String type, String name, int port, int max) {
        try {
            GameFinder gf = new GameFinder(type, name, port, max);
            return gf;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void withdraw() {
        this.close();
    }

    public void setPlayerCount(int count) {
        this.mygame.count = count;
        this.doHello();
    }

    public static void main(String[] args) {
        GameFinder.findGame();
        System.exit(0);
    }

    class Tickler
    implements Runnable {
        Thread anim;
        int delay;
        int ticker = 0;

        public Tickler(int delay) {
            this.delay = delay;
            this.anim = new Thread(this);
            this.anim.start();
        }

        public void reset() {
            ++this.ticker;
        }

        public void stop() {
            this.anim = null;
        }

        public void run() {
            while (this.anim == Thread.currentThread()) {
                int tickinfo = this.ticker;
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {}
                if (this.anim != Thread.currentThread() || tickinfo != this.ticker) continue;
                GameFinder.this.sayHello();
            }
        }
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosed(WindowEvent evt) {
            GameFinder.this.close();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends MouseAdapter {
        public void mouseClicked(MouseEvent evt) {
            GameFinder.this.selectGame(evt);
        }

        /* synthetic */ 2() {
        }
    }
}

