/*
 * Decompiled with CFR 0.152.
 */
package gamefinder;

import java.net.DatagramPacket;
import java.net.InetAddress;

public class Message {
    public static final byte ANNOUNCE = 0;
    public static final byte CHAT = 1;
    public static final byte JOIN = 2;
    public static final byte DROP = 3;
    public static final byte WITHDRAW = 4;
    public static final byte HELLO = 5;
    public static final byte WELCOME = 6;
    public static final String[] protocol = new String[]{"Announce", "Chat", "Join", "Drop", "Withdraw", "Hello", "Welcome"};
    private InetAddress srcaddr;
    private int srcport;
    private byte[] data;
    private byte type;

    public Message(DatagramPacket dp) {
        byte[] info = dp.getData();
        this.type = info[0];
        this.srcaddr = dp.getAddress();
        this.srcport = dp.getPort();
        this.data = new byte[dp.getLength() - 1];
        System.arraycopy(info, 1, this.data, 0, dp.getLength() - 1);
    }

    public Message(byte type, byte[] bytes) {
        this.type = type;
        this.data = new byte[bytes.length + 1];
        this.data[0] = type;
        System.arraycopy(bytes, 0, this.data, 1, bytes.length);
    }

    public String toString() {
        return String.valueOf(this.type) + new String(this.data);
    }

    public byte getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public InetAddress getAddr() {
        return this.srcaddr;
    }

    public int getPort() {
        return this.srcport;
    }
}

