/* do_pgpsignd.c --
 * 
 * This file contains the mail PGPSigner server protocol.  It assumes
 * that we have already authenticated the client, and it will read in
 * the PGP Key, try to verify it, sign it, and return it, or return an
 * error to the user if necessary.
 *
 * Return 0 on success, -1 on error.
 *
 * Created by:	Derek Atkins <warlord@MIT.EDU>
 *
 * Copyright 1994 Derek A. Atkins and the Massachusetts Institute of
 * Technology
 *
 * For copying and distribution information, please see the file
 * <warlord-copyright.h>.
 *
 * $Source: /mit/warlord/C/pgpsign/src/RCS/do_pgpsignd.c,v $
 * $Author: warlord $
 *
 */

#include "warlord-copyright.h"
#include "pgpsign.h"

int
pgpsignd(FILE *infile, FILE *outfile, AUTH_DAT *auth_dat)
{
  char *key;
  int keylen, retval;
  char *error_msg;

  /* Check Args */
  assert (infile != NULL);
  assert (outfile != NULL);

  /* Read in key */
  recvkey(&key, &keylen, &retval, fileno(infile));

  /* Verify keylen */
  if (keylen < 0 || keylen > MAXKEYSIZE) {
    /* Oops! I don't like this key.  Send an error! */
    syslog(LOG_ERR, "Key too bug (%d bytes)", keylen);
    sendkey(KEYTOBIG, sizeof(KEYTOBIG)+1, -1, fileno(outfile));
    return -1;
  }

  syslog(LOG_DEBUG, "Verifying key...");

  /* Verify and sign key */
  if (verify_and_sign_key(key, keylen, auth_dat, &key, &keylen, 
			  &error_msg) != 0) {
    sendkey(error_msg, strlen(error_msg)+1, -1, fileno(outfile));
    return -1;
  }

  /* Send response */
  sendkey(key, keylen, 0, fileno(outfile));

  return 0;
}
