/*
 * pgpsignd -- 
 *
 * This is the server for the Kerberized PGP Signer.  It reads a key
 * from the input file (stdin), and then tries to match the userID
 * on the key with the kerberos principal of the authenticated client,
 * and if that works, then it signs the PGP key and then writes the
 * key out (stdout).  This is based upon an entry in inetd.conf.
 *
 * Created by:	Derek Atkins <warlord@MIT.EDU>
 *
 * Copyright 1994 Derek A. Atkins and the Massachusetts Institute of
 * Technology
 *
 * For copying and distribution information, please see the file
 * <warlord-copyright.h>.
 *
 * $Source: /mit/warlord/C/pgpsign/src/RCS/pgpsignd.c,v $
 * $Author: warlord $
 *
 */

#include "warlord-copyright.h"
#include "pgpsign.h"

char *whoami;

int
main(int argc, char *argv[])
{
  int retval = 0;
  AUTH_DAT auth_dat;
  FILE *infile = stdin;
  FILE *outfile = stdout;

  whoami = argv[0];

  setenv("PGPPATH", PGPPATH, 1);

#ifdef LOG_DAEMON
  openlog("pgpsignd",0,LOG_DAEMON);
#endif
  syslog(LOG_DEBUG, "PGP Signer starting...");

  /* Read in authentication */
  if (authclient(0, &auth_dat)) {
    sendkey("Received Bad Authentication from client", 40, -1,
	    fileno(outfile));
    exit(1);
  }

  retval = pgpsignd(infile, outfile, &auth_dat);

  syslog(LOG_DEBUG, "Done");
  exit(-retval);
}

