/* readkeyfromfile.c --
 *
 * Read from the input file, fp, until we get to the end of the
 * file, and return the allocated buffer and the length of said
 * buffer.
 *
 * Created by:	Derek Atkins <warlord@MIT.EDU>
 *
 * Copyright 1994 Derek A. Atkins and the Massachusetts Institute of
 * Technology
 *
 * For copying and distribution information, please see the file
 * <warlord-copyright.h>.
 *
 * $Source: /mit/warlord/C/pgpsign/src/RCS/readkeyfromfile.c,v $
 * $Author: warlord $
 */

#include "warlord-copyright.h"
#include "pgpsign.h"

void
readkeyfromfile(char **key, int *keylen, FILE *fp)
{
  char buffer[BUFSIZ];

  *keylen = 0;
  *key = NULL;

  while (fgets(buffer, BUFSIZ, fp) != NULL) {
    if (*key == NULL) {
      *key = (char *)malloc(strlen(buffer) + 1);
      strcpy(*key, buffer);
    } else {
      *key = (char *)realloc(*key, *keylen + strlen(buffer) + 1);
      strcat(*key, buffer);
    }

    *keylen += strlen(buffer);
  }

  return;
}

