/* realm_list.c --
 *
 * These functions will parse valid kerberos realms and valid mail
 * domains...  Each will generate a list of valid entries for the
 * input and return that NULL-terminated list to the caller.
 *
 * Created by:	Derek Atkins <warlord@MIT.EDU>
 *
 * Copyright 1994 Derek A. Atkins and the Massachusetts Institute of
 * Technology
 *
 * For copying and distribution information, please see the file
 * <warlord-copyright.h>.
 *
 * $Source: /mit/warlord/C/pgpsign/src/RCS/realm_list.c,v $
 * $Author: warlord $
 *
 */

#define PGPSIGND 1		/* This is in the server! */
#include "warlord-copyright.h"
#include "pgpsign.h"

/*
 * This function will return a NULL-terminated array of strings
 * that comprise the valid kerberos realms.  These are the
 * realms that are accepted by this server (it is possible that
 * a server can sign for multiple realms).
 *
 * XXX: at some point this should be read from a config file,
 * rather than hard-coded into the server.
 */
char **
krb_realm_list()
{
  static char *list[] = KRB_REALM_LIST;

  return(list);
}

/* 
 * This function will return a NULL-terminated array of strings
 * that comprise the valid mail hosts for a given kerberos realm.
 * The realm that is passed in is looked up in some manner and
 * then the list of mail hosts for that realm is returned.  In this
 * way, a single signer may verify and sign keys for different
 * kerberos realms and inforce certain mail addresses on those
 * realms.
 *
 * E.g., warlord@ATHENA.MIT.EDU can get a PGP key signed for
 * <warlord@athena.mit.edu> or <warlord@MIT.EDU>
 *
 * XXX: at some point this should be read from a config file,
 * rather than hard-coded into the server.
 */
char **
mail_realm_list(char *krb_realm)
{
  static char **list[] = MAIL_REALM_LIST;
  char **realm;
  int i;

  /* Check Arg */
  assert (krb_realm != NULL);

  for (i=0, realm = list[i]; realm && *realm && **realm; realm = list[++i]) {
    if (!strcmp(*realm, krb_realm))
      return(++realm);
  }

  return(NULL);
}

