/* recvkey.c --
 * 
 * Read the length of the key, in net-byte order, and then read the
 * key itself, as it is.  The length is assumed to be no more than 4
 * bytes, although it does not matter that an int is that size, just
 * that a key is not that size.  Also return a retval, so we know that
 * the server succeeded.
 *
 * Created by:	Derek Atkins <warlord@MIT.EDU>
 *
 * Copyright 1994 Derek A. Atkins and the Massachusetts Institute of
 * Technology
 *
 * For copying and distribution information, please see the file
 * <warlord-copyright.h>.
 *
 * $Source: /mit/warlord/C/pgpsign/src/RCS/recvkey.c,v $
 * $Author: warlord $
 *
 */

#include "warlord-copyright.h"
#include "pgpsign.h"

void
recvkey(char **key, int *keylen, int *retval, int sock)
{
  unsigned char lenbuf[4];
  int i;

  *keylen = 0;
  *retval = 0;
  *key = "";

  if (krb_net_read(sock, lenbuf, 4) != 4) 
    return;

  for (i=0; i < 4; i++) {
    *keylen *= 256;
    *keylen += lenbuf[i];
  }

  if (krb_net_read(sock, lenbuf, 4) != 4) {
    *keylen = 0;
    return;
  }

  for (i=0; i < 4; i++) {
    *retval *= 256;
    *retval += lenbuf[i];
  }

  /* Sanity check the keylen */
  if (*keylen < 0 || *keylen > MAXKEYSIZE) 
      return;

  *key = (char *)malloc(*keylen + 1);
  bzero(*key, *keylen+1);
  krb_net_read(sock, *key, *keylen);

  return;
}
