/* sendkey.c --
 *
 * Write the length of the key, in net-byte order, and then send the
 * key itself, as it is.  The length is assumed to be no more than 4 bytes,
 * although it does not matter that an int is that size, just that a key
 * is not that size.
 *
 * Created by:	Derek Atkins <warlord@MIT.EDU>
 *
 * Copyright 1994 Derek A. Atkins and the Massachusetts Institute of
 * Technology
 *
 * For copying and distribution information, please see the file
 * <warlord-copyright.h>.
 *
 * $Source: /mit/warlord/C/pgpsign/src/RCS/sendkey.c,v $
 * $Author: warlord $
 *
 */

#include "warlord-copyright.h"
#include "pgpsign.h"

void
sendkey(char *key, int keylen, int val, int sock)
{
  unsigned char lenbuf[4];
  int i, len = keylen;

  for (i=3; i >= 0; i--) {
    lenbuf[i] = len%256;
    len /= 256;
  }

  if (krb_net_write(sock, lenbuf, 4) != 4)
    return;

  /* Send the value.. This is only really useful for the server
   * to respond, but might as well send it anyways, to be more
   * general.
   */
  len = val;
  for (i=3; i >= 0; i--) {
    lenbuf[i] = len%256;
    len /= 256;
  }

  if (krb_net_write(sock, lenbuf, 4) != 4)
    return;

  krb_net_write(sock, key, keylen);
}
