#!/usr/local/bin/perl
#  migrate.pl - upgrade all the old style (dbm) format CBB data files
#               in the specified directory to the new format.
#
#  Usage: migrate.pl <data-dir>
#
#    This involves the following steps:
#
#        (1)  rm *.bal.dir *.bal.pag
#        (2)  mv $file.txn.dir $file.dir
#             mv $file.txn.pag $file.pag
#        (3)  convert transactions from ":" delimited to <tab> delimited
#        (3a) save file in ASCII CBB format and delete dbm file (if ascii)
#        (4)  convert categories file from ":" delimited to <tab> delimited
#
#  WARNING:  BACKUP ALL YOUR DATA FIRST!!!!!!!!!!!!!!!!!!!!!!!!!!!!
#
#  Written by Curtis Olson.  Started July 6, 1995.
#
#  Copyright (C) 1995  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: migrate-to-0.60a.pl,v 1.6 1996/01/21 00:26:28 curt Exp $
# (Log is kept at end of this file)


# specify the installed location of the necessary pieces.
$cbb_incl_dir = "..";
unshift(@INC, $cbb_incl_dir);

require "categories.pl";
require "engine.pl";

($#ARGV >= 0) || 
    die "Usage: upgrade.pl <data-dir>";

print <<"EndOfIntro";
This program migrates your old style (pre 0.60 version) data files to
the new CBB format.  CBB currently supports two separate data file
formats: a simple ASCII text file format (recommended) and dbm data
base format.  The only advantage gained by using the dbm format is
your transactions are immediately saved.  However, with ASCII format
files, CBB will automatically save a temporary copy of your current
account at periodic time intervals.  This makes using the ASCII format
nearly as safe as using the dbm format.  From a performance
standpoint, both are about equivalent although some dbm operations may
be a bit slower.

Personally I recommend the ASCII format.

EndOfIntro

print "Which format do you wish to migrate to? (ascii/dbm) [ascii] ";

$response = <STDIN>;
chop($response);

if ( ($response eq "") || ($response =~ m/^ascii$/i) ) {
    print "\nOk, using ASCII format.  You won't be sorry!\n";
    $format = "ascii";
} elsif ( $response =~ m/^dbm$/i ) {
    print "\n(Grumble) ... ok, if you really want to ...\n";
    $format = "dbm";
} else {
    die "\nHmmm, I don't think I support the '$response' format.\n";
}

print <<"EndOfWarning";

Ready to migrate data to $format format.

This migration will involve the following steps:

        (1)  rm *.bal.dir *.bal.pag
        (2)  mv \$files.txn.dir \$files.dir
             mv \$files.txn.pag \$files.pag
        (3)  convert transactions from ':' delimited to <tab> delimited
        (3a) save file in ASCII CBB format and delete dbm file
        (4)  convert categories file from ':' delimited to <tab> delimited

Note: step (3a) is only performed when migrating to ASCII format.

You are strongly encouraged to make BACKUPS of all your data before
attempting to do this!!!

EndOfWarning

print "Do you wish to continue? (yes/no) [no] ";

$response = <STDIN>;

if ( $response =~ m/yes/i ) {
    print "Ok, continuing:\n\n";
} else {
    die "Bailing out ... nothing was done to your data.\n";
}


$dir = shift(@ARGV);

-e $dir || die "Specified data directory:  '$dir' does not exist\n";

if ( -e "$dir/categories.dir" ) {
    print "Converting categories file from ':' delimited to <tab> delimited\n";
    ( &load_dbm_cats("$dir/categories") ne "error" ) || 
	    die "Cannot load categories file\n";

    print "  loaded categories\n";
    foreach $key ( sort keys %CATS ) {
        $CATS{$key} =~ s/:/\t/g;
    }

    print "Creating category file $dir/categories\n";
    &save_cats("$dir/categories");

    print "Removing $dir/categories.dir and $dir/categories.pag\n";
    system("rm $dir/categories.dir $dir/categories.pag");

    print "\n";
}

print "Removing $dir/\*.bal.dir $dir/\*.bal.pag ...\n";
system("rm $dir/\*.bal.dir $dir/\*.bal.pag");

print "\n";
foreach $file ( `ls $dir/*.txn.dir` ) {
    $pos = rindex($file, ".");
    $base = substr($file, 0, $pos);
    $pos = rindex($base, ".");
    $base = substr($base, 0, $pos);

    print "Moving $base.txn.dir to $base.dir\n";
    print "Moving $base.txn.pag to $base.pag\n";
    system("mv $base.txn.dir $base.dir");
    system("mv $base.txn.pag $base.pag");
}

print "\n";
foreach $account ( `ls $dir/*.dir` ) {
    print "Account = $account";
    chop($account);

    $pos = rindex($account, ".");
    $base = substr($account, 0, $pos);

    print "Converting $base from ':' delimited to <tab> delimited\n";

    $result = &load_trans($account);

    die "Cannot open account:  $account" if ( $result eq "error" );

    # %TRANS & @KEYS are setup during the load_trans() call
    foreach $key ( sort keys %TRANS ) {
        $TRANS{$key} =~ s/:/\t/g;
	$TRANS{$key} = &fix_splits($TRANS{$key});
    }

    if ( $format eq "ascii" ) {
	print "  Creating $base.cbb\n";
        &save_trans("$base.cbb");
	print "  Removing $base.dir and $base.pag\n";
	system("rm $base.dir $base.pag");
    }
}

print "\n";
print "Successfully migrated to new format ... we hope :)\n";


# ----------------------------------------------------------------------------
# $Log: migrate-to-0.60a.pl,v $
# Revision 1.6  1996/01/21  00:26:28  curt
# Correct copyright date
#
# Revision 1.5  1996/01/12  13:21:31  curt
# Added a debugging line.
#
# Revision 1.4  1995/07/20  02:47:55  curt
# Added line to upgrade splits to include comment field.
#
# Revision 1.3  1995/07/09  03:20:28  curt
# Changed some line breaking
#
# Revision 1.2  1995/07/08  03:51:18  curt
# Fixed a couple of small bugs
#
# Revision 1.1  1995/07/08  01:37:26  curt
# Initial add to repository
#
