#!/usr/local/bin/perl
#  file.pl - routines to help with file management
#
#  Written by Curtis Olson.  Started April 22, 1994.
#
#  Copyright (C) 1994, 1995, 1996  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: file.pl,v 1.3 1996/01/21 02:18:49 curt Exp $
# (Log is kept at end of this file)


# given a directory and an extension mask (: separated list) return a
# list of files that match (including all directories)
sub get_files {
    local($dir, $mask) = split(/ +/, $_[0]);
    local($file, $ext, $count, @files, @sorted);

    print DEBUG "Directory = $dir\n";
    print DEBUG "Mask = $mask\n";

    $count = 0;

    opendir(DIR, $dir);
    $file = readdir(DIR);	# skip "."
    $file = readdir(DIR);	# skip ".."
    $file = readdir(DIR);
    while ( defined($file) ) {
	$ext = &file_extension($file);
	# print "$file --- $ext\n";
	if ( (($mask =~ m/:$ext:/) && ($file ne $ext)) || (-d "$dir/$file") ) {
	    # print "$file\n";
	    $files[$count] = $file;
	    $count++;
	}
	$file = readdir(DIR);
    }
    closedir(DIR);

    @sorted = sort @files;
    foreach $file (@sorted) {
	print "$file\n";
    }
    return "//none//";
}


1;				# need to return a true value


# ----------------------------------------------------------------------------
# $Log: file.pl,v $
# Revision 1.3  1996/01/21  02:18:49  curt
# Modified Files:  categories.pl common.pl engine.pl export.pl file.pl import.pl
#                  log.pl memorized.pl reports.pl wrapper.pl
#   Updated copyright date.
#
# Revision 1.2  1995/08/03  22:59:01  curt
# Added work around to avoid perl5 seg fault bug.
#
# Revision 1.1  1995/04/24  02:00:04  curt
# Herein lies some file support routines.
#
