#!/usr/local/bin/perl
#  install.pl - the CBB install utility
#              This script installs CBB
#
#  Written by Curtis Olson.  Started October 11, 1994.
#
#  Copyright (C) 1994, 1995, 1996  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: install.pl,v 1.25 1996/02/11 20:23:13 curt Exp $
# (Log is kept at end of this file)


require "common.pl";


# tcl execs
@tcl_execs = ("cbb", "conf-reports");

# perl binaries
@perl_bins = ("wrapper.pl");

# tcl includes
@tcl_incs = ("bindings.tk", "categories.tk", "common.tk", "file.tk", 
		"filebox.tk", "main.tk", "menu.tk");

# perl includes
@perl_incs = ("categories.pl", "common.pl", "engine.pl", "export.pl", 
		"file.pl", "import.pl", "log.pl", "memorized.pl", 
		"reports.pl");

# reports
@reports = ("reports.conf", "rep-by-cat-shrt.pl", "rep-by-cat.pl", 
	    "rep-txn-list.pl");

# graphs
@graphs = ("graphs.conf", "grph-txn-list.pl");

# other files
@other_files = ("author.xbm", "cbb.xbm", "csh.src", "default.cat", 
		"extern.conf");

# contributed stuff
@contrib = ("invest.pl", "migrate-to-0.60a.pl", "recur.pl", 
	    "upgrade-splits.pl", "yearend.pl");

# possible browsers
@browsers = ("netscape", "Mosaic", "mosaic", "rmosaic", "lynx");

# get home directory
@pw = getpwuid($<);

$HOME = $pw[7]
     || $ENV{HOME}
     || $ENV{LOGDIR}
     || die "No home directory";

$home_dir = &file_dirname($HOME);
$home_base = &file_basename($HOME);
 
# default paths
$def_perlpath = "";
@perl_poss = ("/usr/bin/perl", "/usr/local/bin/perl");
$def_wishpath = "";
@wish_poss = ("/usr/bin/wish4.0", "/usr/bin/X11/wish4.0", 
              "/usr/local/bin/wish4.0", "/usr/bin/wish", "/usr/bin/X11/wish", 
	      "/usr/local/bin/wish");

$def_binpath = `( cd /; which cbb )`;
  $pos = rindex($def_binpath, "/");
  $def_binpath = substr($def_binpath, 0, $pos);
  if ( $def_binpath =~ m/ / ) {
        $def_binpath = "/usr/local/bin";
  }
  $def_binpath .= "/";

$def_libpath = "";
$def_version = "Version";
$def_icon = "cbb.xbm";
$def_man = "cbb-man";


print "\nInstalling and Configuring CBB:\n";
print "Press ^C at any time to abort.\n\n";

# Ok, first lets find out the current version

open( VERSION, "$def_version" );
$version = <VERSION>;
chop($version);

print "Current version is \"$version\"\n\n";

print "    NOTE:  You may use ~ and ~user to specify a home directory as\n";
print "           part of an installation directory.\n\n";

# Now, make sure we have the prerequisites.

foreach $tmp (@perl_poss) {
    if ( (-e $tmp) && ($def_perlpath eq "") ) {
	$def_perlpath = $tmp;
    }
}

$perlpath = "";
while ( $perlpath eq "" ) {
    print "What is the name of your perl binary? [$def_perlpath] ";
    $perlpath = <STDIN>;
    chop($perlpath);

    if ( $perlpath eq "" ) {
	$perlpath = $def_perlpath;
    }

    # psuedo-glob
    if ( $perlpath =~ m/~\// ) {
        # ~/blah form
        $perlpath =~ s/~/$HOME/;
    } else {
        # ~user/blah from
        $perlpath =~ s/~/$home_dir/;
    }

    if ( ! -e $perlpath ) {
	$perlpath = "";
    }
}
print "    Using $perlpath\n";

foreach $tmp (@wish_poss) {
    if ( (-e $tmp) && ($def_wishpath eq "") ) {
	$def_wishpath = $tmp;
	break;
    }
}

$wishpath = "";
while ( $wishpath eq "" ) {
    print "What is the name of your wish (tk4.0) binary [$def_wishpath] ";
    $wishpath = <STDIN>;
    chop($wishpath);

    if ( $wishpath eq "" ) {
	$wishpath = $def_wishpath;
    }

    # psuedo-glob
    if ( $wishpath =~ m/~\// ) {
        # ~/blah form
        $wishpath =~ s/~/$HOME/;
    } else {
        # ~user/blah from
        $wishpath =~ s/~/$home_dir/;
    }

    if ( ! -e $wishpath ) {
	$wishpath = "";
    }
}
print "    Using $wishpath\n";


# check for a web browser

$def_browser = "no-browser";

foreach $browser (@browsers) {
    print "Looking for $browser\n";
    $temp = `( cd /; which $browser )`;
    chop($temp);
    $pos = rindex($temp, "/");
    $temp = substr($temp, 0, $pos);
    # print "'$temp'\n";
    if ( $temp !~ m/ / ) {
	if ( $def_browser eq "no-browser" ) {
	    $def_browser = $browser;
	    # print "choosing $def_browser\n";
	    break;
	}
    }
}

if ( $def_browser eq "" ) {
    print "Warning:  cannot find a web browser.  CBB uses this for online help.\n"
} else {
    print "Found $def_browser.  CBB will use this for online help.\n";
}


# check for Mosaic & gnuplot

$gnuplot = `( cd /; which gnuplot )`;
$pos = rindex($gnuplot, "/");
$gnuplot = substr($gnuplot, 0, $pos);
if ( $gnuplot =~ m/ / ) {
    print "Warning:  cannot find gnuplot.  CBB uses this for graphing.\n"
} else {
    print "Found gnuplot.  CBB uses this for graphing.\n"
}

# Now, where do we want to install things ...

$binpath = "";
while ( $binpath eq "" ) {
    print "Where should the binaries be installed? [$def_binpath] ";
    $binpath = <STDIN>;
    chop($binpath);

    if ( $binpath eq "" ) {
	$binpath = $def_binpath;
    }

    # psuedo-glob
    if ( $binpath =~ m/~\// ) {
	# ~/blah form
	$binpath =~ s/~/$HOME/;
    } else {
	# ~user/blah from
	$binpath =~ s/~/$home_dir/;
    }

    if ( ! -e $binpath || ! -d $binpath ) {
	print "    $binpath does not exist.  Should I create it? [y] ";
	$result = <STDIN>;
	chop($result);
	if ( ($result =~ /^[Yy]/) || ($result eq "") ) {
	    $status = system( "mkdir $binpath" );
	    if ( $status ) {
		$code = $status / 256;
		print"\'mkdir $binpath\' failed with an exit code of ";
		print"$code.\n";
		exit( $code );
	    }
	    chmod(0755, $binpath);
	} else {
	    print "    Very well ... but you better do it yourself. ;)\n";
	}
    }

    if ( $binpath =~ m/wish$/ ) {
	print "    Warning:  CBB cannot run with wish, it requires bin.\n";
	print "    See the README file for more information.\n";
	$binpath = "";
    }
}
print "    Using $binpath\n";

# derive a default $libpath from $binpath
$tmp = $binpath;
if ( substr($tmp, length($tmp) - 1) eq "/" ) {
    chop($tmp);
}
$def_libpath = &file_dirname($tmp) . "lib/cbb/";

$libpath = "";
while ( $libpath eq "" ) {
    print "Where should the support files be installed? [$def_libpath] ";
    $libpath = <STDIN>;
    chop($libpath);

    if ( $libpath eq "" ) {
	$libpath = $def_libpath;
    }

    # psuedo-glob
    if ( $libpath =~ m/~\// ) {
        # ~/blah form
        $libpath =~ s/~/$HOME/;
    } else {
        # ~user/blah from
        $libpath =~ s/~/$home_base/;
    }

    if ( ! -e $libpath || ! -d $libpath ) {
	print "    $libpath does not exist.  Should I create it? [y] ";
	$result = <STDIN>;
	chop($result);
	if ( ($result =~ /^[Yy]/) || ($result eq "") ) {
	    $status = system( "mkdir $libpath" );
	    if ( $status ) {
		$code = $status / 256;
		print"\'mkdir $libpath\' failed with an exit code of ";
		print"$code.\n";
		exit( $code );
	    }
	    chmod(0755, $libpath);
	} else {
	    print "    Very well ... but you better do it yourself. ;)\n";
	}
    }

    if ( $libpath =~ m/wish$/ ) {
	print "    Warning:  CBB cannot run with wish, it requires lib.\n";
	print "    See the README file for more information.\n";
	$libpath = "";
    }
}

$reportpath = "$libpath/reports";
if ( ! -e $reportpath || ! -d $reportpath ) {
    system( "mkdir $reportpath" );
    chmod(0755, $reportpath);
}

$graphpath = "$libpath/graphs";
if ( ! -e $graphpath || ! -d $graphpath ) {
    system( "mkdir $graphpath" );
    chmod(0755, $graphpath);
}

$contribpath = "$libpath/contrib";
if ( ! -e $contribpath || ! -d $contribpath ) {
    system( "mkdir $contribpath" );
    chmod(0755, $contribpath);
}

$cbb_manpath = "$libpath/cbb-man";
if ( ! -e $cbb_manpath || ! -d $cbb_manpath ) {
    system( "mkdir $cbb_manpath" );
    chmod(0755, $cbb_manpath);
}

$iconpath = "$cbb_manpath/icons";
if ( ! -e $iconpath || ! -d $iconpath ) {
    system( "mkdir $iconpath" );
    chmod(0755, $iconpath);
}

print "    Using $libpath\n";
print "    Using $reportpath\n";
print "    Using $graphpath\n";
print "    Using $contribpath\n";
print "    Using $cbb_manpath\n";
print "    Using $iconpath\n";


# install CBB

print ( "\nNow installing CBB:\n" );

&my_print_init();
&my_print("\nInstalling executables:  ");

foreach $file ( @tcl_execs ) {
    # print ( "Creating $binpath/$file from ./$file\n" );
    &my_print("$file ");

    open( TCLIN, "<./$file" ) || die "Cannot open ./$file";
    open( TCLOUT, ">$binpath/$file" ) || die "Cannot create $binpath/$file";

    $junk = <TCLIN>;	# ignore first line
    print( TCLOUT "#!$wishpath -f\n" );

    while ( <TCLIN> ) {
        s/^ *set lib_path.*$/set lib_path \"$libpath\"/;
        s/\"Version <not_installed>.*\"/\"$version\"/;
        print( TCLOUT $_ );
    }

    close( TCLIN );
    close( TCLOUT );

    chmod(0755, "$binpath/$file") || die "Cannot chmod $binpath/$file";
}


# install perl bins

foreach $file (@perl_bins) {
    # print ( "Creating $binpath/$file from ./$file\n" );
    &my_print("$file ");

    open( PERLBININ, "<./$file" ) || die "Cannot open ./$file";
    open( PERLBINOUT, ">$binpath/$file" ) 
	    || die "Cannot create $binpath/$file";

    $junk = <PERLBININ>;	# ignore first line
    print( PERLBINOUT "#!$perlpath\n" );

    while ( <PERLBININ> ) {
        s/^ *\$cbb_incl_dir = .*$/\$cbb_incl_dir = \"$libpath\";/;
        print( PERLBINOUT $_ );
    }

    close( PERLBININ );
    close( PERLBINOUT );

    chmod(0755, "$binpath/$file") || die "Cannot chmod $binpath/$file";
}


# install perl includes

&my_print_init();
&my_print("\nInstalling perl includes:  ");

foreach $file (@perl_incs) {
    # print ( "Creating $libpath/$file from ./$file\n" );
    &my_print("$file ");

    open( INCIN, "<./$file" ) || die "Cannot open ./$file";
    open( INCOUT, ">$libpath/$file" ) 
	|| die "Cannot create $libpath/$file";
    
    $junk = <INCIN>;	# ignore first line
    print( INCOUT "#!$perlpath\n" );

    while ( <INCIN> ) {
	s/^ *\$cbb_incl_dir = .*$/\$cbb_incl_dir = \"$libpath\";/;
        s/\"Version <not_installed>.*\"/\"$version\"/;
	print( INCOUT $_ );
    }

    close( INCIN );
    close( INCOUT );

    chmod(0644, "$libpath/$file") || die "Cannot chmod $libpath/$file";
}


# install reports

&my_print_init();
&my_print("\nInstalling report files:  ");

foreach $file (@reports) {
    # print ( "Creating $reportpath/$file from ./$file\n" );
    &my_print("$file ");

    open( INCIN, "<./reports/$file" ) || die "Cannot open ./reports/$file";
    open( INCOUT, ">$reportpath/$file" ) 
        || die "Cannot create $reportpath/$file";
    
    $junk = <INCIN>;    # ignore first line
    if ( $junk =~ m/perl/ ) {
        print( INCOUT "#!$perlpath\n" );
    } else {
	print( INCOUT $junk );
    }

    while ( <INCIN> ) {
        s/^ *\$cbb_incl_dir = .*$/\$cbb_incl_dir = \"$libpath\";/;
        print( INCOUT $_ );
    }

    close( INCIN );
    close( INCOUT );

    chmod(0755, "$reportpath/$file") || die "Cannot chmod $reportpath/$file";
}


# install graphs

&my_print_init();
&my_print("\nInstalling graph files:  ");

foreach $file (@graphs) {
    # print ( "Creating $graphpath/$file from ./$file\n" );
    &my_print("$file ");

    open( INCIN, "<./graphs/$file" ) || die "Cannot open ./graphs/$file";
    open( INCOUT, ">$graphpath/$file" ) 
        || die "Cannot create $graphpath/$file";
    
    $junk = <INCIN>;    # ignore first line
    if ( $junk =~ m/perl/ ) {
        print( INCOUT "#!$perlpath\n" );
    } else {
	print( INCOUT $junk );
    }

    while ( <INCIN> ) {
        s/^ *\$cbb_incl_dir = .*$/\$cbb_incl_dir = \"$libpath\";/;
        print( INCOUT $_ );
    }

    close( INCIN );
    close( INCOUT );

    chmod(0755, "$graphpath/$file") || die "Cannot chmod $graphpath/$file";
}


# install tcl includes

&my_print_init();
&my_print("\nInstalling tcl includes:  ");

foreach $file (@tcl_incs) {
    # print ( "Creating $libpath/$file from ./$file\n" );
    &my_print("$file ");

    open( INCIN, "<./$file" ) || die "Cannot open ./$file";
    open( INCOUT, ">$libpath/$file" )
        || die "Cannot create $libpath/$file";
   
    while ( <INCIN> ) {
        if ( m/\s+exec Mosaic.*$/ ) {
	    print( INCOUT "        exec $def_browser \$lib_path/cbb-man/cbb-man.html \&\n");
	} else {
            print( INCOUT $_ );
	}
    }

    close( INCIN );
    close( INCOUT );

    chmod(0644, "$libpath/$file") || die "Cannot chmod $libpath/$file";
}


# install other files

&my_print_init();
&my_print("\nInstalling other files:  ");

foreach $file (@other_files) {
    # print ( "Creating $libpath/$file from ./$file\n" );
    &my_print("$file ");

    open( OTHERIN, "<./$file" ) || die "Cannot open ./$file";
    open( OTHEROUT, ">$libpath/$file" )
        || die "Cannot create $libpath/$file";
   
    while ( <OTHERIN> ) {
        print( OTHEROUT $_ );
    }

    close( OTHERIN );
    close( OTHEROUT );

    chmod(0644, "$libpath/$file") || die "Cannot chmod $libpath/$file";
}


&my_print_init();
&my_print("\nInstalling other contributed stuff:  ");

foreach $file (@contrib) {
    # print ( "Creating $contribpath/$file from ./contrib/$file\n" );
    &my_print("$file ");

    open( CONTRIBIN, "<./contrib/$file" ) || die "Cannot open ./contrib/$file";
    open( CONTRIBOUT, ">$contribpath/$file" )
        || die "Cannot create $contribpath/$file";
   
    $junk = <CONTRIBIN>;	# ignore first line
    print( CONTRIBOUT "#!$perlpath\n" );

    while ( <CONTRIBIN> ) {
        s/^ *\$cbb_incl_dir = .*$/\$cbb_incl_dir = \"$libpath\";/;
        print( CONTRIBOUT $_ );
    }

    close( CONTRIBIN );
    close( CONTRIBOUT );

    chmod(0755, "$contribpath/$file") || die "Cannot chmod $contribpath/$file";
}


# install cbb_man files

&my_print_init();
&my_print("\nInstalling CBB online manual:  ");

foreach $file (`ls $def_man/*.html`) {
    $file = &file_basename($file);
    chop($file);
    # print ( "Creating $cbb_manpath/$file from ./$def_man/$file\n" );
    &my_print("$file ");

    open( MANIN, "<./$def_man/$file" ) || die "Cannot open ./$def_man/$file";
    open( MANOUT, ">$cbb_manpath/$file" )
        || die "Cannot create $cbb_manpath/$file";
   
    while ( <MANIN> ) {
	s/\/usr\/local\/src\/www\/latex2html\/icons\//$iconpath\//g;
        print( MANOUT $_ );
    }

    close( MANIN );
    close( MANOUT );

    chmod(0644, "$cbb_manpath/$file") || die "Cannot chmod $cbb_manpath/$file";
}

foreach $file (`ls $def_man/*.gif`) {
    $file = &file_basename($file);
    chop($file);
    &my_print("$file ");

    system("cp ./$def_man/$file $cbb_manpath/$file");
    chmod(0644, "$cbb_manpath/$file") || die "Cannot chmod $cbb_manpath/$file";
}


foreach $file (`ls $def_man/icons/*`) {
    $file = &file_basename($file);
    chop($file);
    &my_print("$file ");

    system("cp ./$def_man/icons/$file $iconpath/$file");
    chmod(0644, "$iconpath/$file") || die "Cannot chmod $iconpath/$file";
}


print "\n\nInstallation successful.  Make sure '$binpath' is in your \$PATH, \n";
print "then type 'cbb' and have fun!\n";
print "\n";
print "Please send comments and suggestions to 'curt\@sledge.mn.org'\n";


sub my_print_init {
    $first_line = 1;
    $cur_len = 0;
}


sub my_print {
    local($line) = @_[0];

    if ( length($line) + $cur_len < 75 ) {
        print $line;
    } else {
	$cur_len = 0;
	if ( $first_line ) {
	    print "\n$line";
	} else {
	    print "\n    $line";
	}
    }

    $first_line = 0;
    $cur_len += length($line);
}


# ----------------------------------------------------------------------------
# $Log: install.pl,v $
# Revision 1.25  1996/02/11  20:23:13  curt
# Favor netscape for online manual browser.
#
# Revision 1.24  1996/02/05  01:49:03  curt
# Changed several instances of cbb to CBB.
#
# Revision 1.23  1996/01/21  02:18:03  curt
# Lots of mods ... (oh? you wanted details?)
#
# Revision 1.22  1996/01/12  13:23:56  curt
# Minor output line format change
#
# Revision 1.21  1995/08/18  11:32:49  curt
# Set permissions to 755 on any directory we create.
#
# Revision 1.20  1995/08/03  23:57:08  curt
# Reworked a bunch of stuff.
#
# Revision 1.19  1995/07/20  02:49:21  curt
# Made changes to install new files.
#
# Revision 1.18  1995/07/14  11:47:05  curt
# Tweaked cbb locater for default bin path
#
# Revision 1.17  1995/07/09  03:24:20  curt
# install will now try to find an existing copy of cbb and make its location
# the default bin dir.
#
# Revision 1.16  1995/07/08  01:52:25  curt
# Fold current version into perl scripts as well as tk scripts.
#
# Revision 1.15  1995/07/04  23:03:58  curt
# Made changes to reflect .../cbb/reports and .../cbb/graphs
#
# Revision 1.14  1995/06/07  03:33:08  curt
# Modified Files:  Makefile cbb cbb-man.tex install.pl
# Added Files:  main.tk
#   Moved most of the main window related routines to main.tk
#
# Revision 1.13  1995/06/04  13:24:14  curt
# Added file.pl, file.tk, and menu.tk
#
# Revision 1.12  1995/02/23  05:13:14  curt
# Removed dependencies on tclX (wishx).
#
# Revision 1.11  1995/01/23  04:15:17  curt
# Added psuedo-globbing.
#
# Revision 1.10  1994/12/01  12:47:52  clolson
# Added an icon bitmap
#
# Revision 1.9  1994/11/29  19:03:34  curt
# Smartened the bad boy up.
#
# Revision 1.8  1994/11/28  18:55:32  clolson
# Added reports.pl & reports.tk
#
# Revision 1.7  1994/11/07  23:14:04  clolson
# Working on interactive category viewing/editing
#
# Revision 1.6  1994/11/07  19:16:12  clolson
# Added latex2tkhlp to install.
#
# Revision 1.5  1994/11/01  22:39:13  clolson
# Added log.pl --> implemented logging.
# Worked on install script.
#
# Revision 1.4  1994/10/31  16:04:56  curt
# Beginning some massive changes to start tracking towards cbbsh.
#
# Revision 1.3  1994/10/14  19:06:42  clolson
# Fixed a problem:  didn't add -f to the end of wish in the installed cbb.
#
# Revision 1.2  1994/10/14  03:04:49  curt
# First working version.
#
# Revision 1.1  1994/10/11  21:21:17  clolson
# Initial add to repository
#

