/* $Id: displayLimit.c,v 1.1 1996/06/15 19:33:07 lupus Exp lupus $ */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <string.h>

#include "displayLimit.h"
#include "datoPrint.h"

extern Widget displayLimitFromInput, displayLimitToInput; /* in window.c */

Date getDisplayFromLimit() {
  String p;
  
  if(!displayLimitFromInput)
    return 0;

  XtVaGetValues(displayLimitFromInput,
		XtNstring, &p,
		NULL); 
  if(strlen(p)==0)
    return 0;
  
  return parseDate(p);
}

Date getDisplayToLimit() {
  String p;
  
  if(!displayLimitToInput)
    return 0;

  XtVaGetValues(displayLimitToInput,
		XtNstring, &p,
		NULL); 
  if(strlen(p)==0)
    return 0;
  
  return parseDate(p);
}

void setDisplayFromLimit(Date d) {
  char *s;

  if(!displayLimitFromInput)
    return;
  
  if( d==0 )
    s="";
  else
    s=dateString(d);
  
  XtVaSetValues(displayLimitFromInput,
		XtNstring, s,
		NULL); 
}

void setDisplayToLimit(Date d) {
  char *s;

  if(!displayLimitToInput)
    return;

  if( d==0 )
    s="";
  else
    s=dateString(d);
  
  XtVaSetValues(displayLimitToInput,
		XtNstring, s,
		NULL); 
}
