/* $Id: info.c,v 4.1 1995/08/10 20:37:01 lupus Exp lupus $ */

#include "infop.h"
#include "info.h"
#include "country.h"
#include "hyper.h"
#include "str.h"
#include "stringstack.h"

#define BWIDTH 60

Widget infoShell, infoPane, infoBox, infoNextLabel,
  infoText, infoClose, infoBack, infoNext, infoContents;

static int popup=0;
static char *currentText;
static char *theNextLink="";
static char currentLink[LINK_MAX_LEN];

static void setnextlink() {
  char buf[LINK_MAX_LEN];
  strcpy(buf, "Next: ");
  zeroAddStrncpy(buf+6, theNextLink, LINK_MAX_LEN-10);
  XtVaSetValues(infoNextLabel,
		XtNlabel, buf,
		NULL);
}  

void button1pressed(Widget w, XEvent *event, 
		    String *params, Cardinal *num_params)
{
  XawTextPosition n;
  char *link, *text;

  n=XawTextGetInsertionPoint(infoText);
  /* printf("Ja, knap 1: %d\n", n); */
  /* printf("%s\n", linkAtPosition(currentText,n));  */

  link=linkAtPosition(currentText,n);
  if(strcmp(link,"nolink")) {   /* if not "nolink" */
    text=bodyText(link);
    if(strcmp(text,"nomatch")) {   /* if not "nomatch" */
      stringpush(currentLink);
      strcpy(currentLink,link);
      theNextLink=nextlink(currentLink);
      setnextlink();
      currentText=text;
      XtVaSetValues(infoText,       
		    XtNstring, currentText,
		    NULL);
    }
  }
}

void createInfoWidgets(void) {
  static int done=0;

  String trans = "<Btn1Down>: select-start() button_press()";

  if(done)
    return;
  done=1;

  zeroAddStrncpy(currentLink,ROOT_NODE,LINK_MAX_LEN-1);
  hyperInit(HYPER_FILE);
  theNextLink=nextlink(currentLink);
  stringpush(currentLink);

  infoShell = XtVaCreatePopupShell (
				      "infoShell",
				      transientShellWidgetClass,
				      topLevel,
				      XtNtitle, HELP_TITLE,
				      NULL );
  
  infoPane = XtVaCreateManagedWidget(
				       "infoPane",
				       panedWidgetClass,
				       infoShell,
				       XtNheight, 340,
				       XtNwidth, 490,
				       NULL);
  
  infoBox = XtVaCreateManagedWidget(
				   "infoBox",
				   boxWidgetClass,
				   infoPane,
				   NULL);

  infoClose = XtVaCreateManagedWidget(
				      "infoClose",
				      commandWidgetClass,
				      infoBox,
				      XtNlabel, CLOSE,
				      XtNwidth, BWIDTH,
				      NULL);

  infoContents = XtVaCreateManagedWidget(
					 "infoContents",
					 commandWidgetClass,
					 infoBox,
					 XtNlabel, CONTENTS,
					 XtNwidth, BWIDTH,
					 NULL);

  infoBack = XtVaCreateManagedWidget(
				     "infoBack",
				     commandWidgetClass,
				     infoBox,
				     XtNlabel, BACK,
				     XtNwidth, BWIDTH,
				     NULL);
  
  infoNext = XtVaCreateManagedWidget(
				     "infoNext",
				     commandWidgetClass,
				     infoBox,
				     XtNlabel, NEXT,
				     XtNwidth, BWIDTH,
				     NULL);

  infoNextLabel = XtVaCreateManagedWidget(
				     "infoNextLabel",
				     labelWidgetClass,
				     infoBox,
				     NULL);
  setnextlink();

  infoText = XtVaCreateManagedWidget(
				     "infoText",
				     asciiTextWidgetClass,
				     infoPane,
				     XtNeditType, XawtextRead,
				     /* XtNdisplayCaret, False, */
				     XtNscrollVertical, XawtextScrollWhenNeeded,
				     XtNstring, (currentText=bodyText(ROOT_NODE)),
				     XtNtranslations, XtParseTranslationTable(trans),
				     NULL);

  addInfoCallBack();
}

void addInfoCallBack(void) {
  XtAddCallback(infoClose, XtNcallback, InfoClose, topLevel);
  XtAddCallback(infoNext, XtNcallback, InfoNext, topLevel);
  XtAddCallback(infoBack, XtNcallback, InfoBack, topLevel);
  XtAddCallback(infoContents, XtNcallback, InfoContents, topLevel);
}

/* ========================================================== */     
void InfoPopup(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  if( !popup ) {
    createInfoWidgets();

    /*  XtSetSensitive(infoKnap,FALSE); */
    XtPopup(infoShell, XtGrabNone);
    popup=1;
  }
/*  else {
    XtPopdown(infoShell);
    popup=0;
  }
*/
}

void InfoClose(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  XtPopdown(infoShell);
  popup=0;
}

void InfoNext(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  char *link, *text;

  link=nextlink(currentLink);
  if(strcmp(link,"nolink")) {   /* if not "nolink" */
    text=bodyText(link);
    if(strcmp(text,"nomatch")) {   /* if not "nomatch" */
      stringpush(currentLink);
      strcpy(currentLink,link);
      theNextLink=nextlink(currentLink);
      setnextlink();
      currentText=text;
      XtVaSetValues(infoText,       
		    XtNstring, currentText,
		    NULL);
    }
  }
}

void InfoContents(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  stringpush(currentLink);
  zeroAddStrncpy(currentLink,ROOT_NODE,LINK_MAX_LEN-1);
  theNextLink=nextlink(currentLink);
  setnextlink();
  currentText=bodyText(currentLink);
  XtVaSetValues(infoText,       
		XtNstring, currentText,
		NULL);
}

void InfoBack(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  char *link, *text;

  link=stringpop();
  if(strcmp(link,"nolink")) {   /* if not "nolink" */
    text=bodyText(link);
    if(strcmp(text,"nomatch")) {   /* if not "nomatch" */
      strcpy(currentLink,link);
      theNextLink=nextlink(currentLink);
      setnextlink();
      currentText=text;
      XtVaSetValues(infoText,       
		    XtNstring, currentText,
		    NULL);
    }
  }
}

void find_info(char *helpl) {
  char *text;
  if( !popup ) {
    createInfoWidgets();
    
    /*  XtSetSensitive(infoKnap,FALSE); */
    XtPopup(infoShell, XtGrabNone);
    popup=1;
  }

  if(strcmp(helpl,"nolink")) {   /* if not "nolink" */
    text=bodyText(helpl);
    if(strcmp(text,"nomatch")) {   /* if not "nomatch" */
      stringpush(currentLink);
      strcpy(currentLink,helpl);
      theNextLink=nextlink(currentLink);
      setnextlink();
      currentText=text;
      XtVaSetValues(infoText,       
		    XtNstring, currentText,
		    NULL);
    }
  }
}
