/*
 * @OSF_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log: string.h,v $
 * Revision 1.1.7.2  1996/04/22  08:40:00  stephen
 * 	Made sure that prototypes are used for ppc builds as we don't
 * 	currently use builtins in this case.
 * 	[1996/04/22  08:33:03  stephen]
 *
 * Revision 1.1.7.1  1996/04/11  13:47:10  barbou
 * 	Build on Linux:
 * 	reorganized routine declarations to avoid declaring those that are
 * 	already defined as GCC builtins on Linux.
 * 	[1996/03/15  15:17:00  barbou]
 * 	Self-Contained Mach Distribution:
 * 	created.
 * 	[95/12/28            barbou]
 * 	[96/03/28            barbou]
 * 
 * $EndLog$
 */

#ifndef	_PURE_MACH_STRING_H_
#define	_PURE_MACH_STRING_H_	1

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned long   size_t;
#endif

#ifdef	MACH_KERNEL

#include <mach/vm_types.h>

extern char 	*strcat(char *, const char *);
extern size_t	strlen(const char *);
extern char 	*strcpy(char *, const char *);
extern int	strcmp(const char *, const char *);
extern int	strncmp(const char *, const char *, size_t);
extern char 	*strncpy(char *, const char *, size_t);
#if defined(linux) && defined(i386)
/* memcpy is a builtin routine */
#else	/* linux && i386 */
extern void	*memcpy(void *, const void *, size_t);
#endif	/* linux && i386 */
extern void	*memset(void *, int, size_t);

#else	/* MACH_KERNEL */

#ifndef	NULL
#define NULL	(void *)0
#endif

#if defined(linux) && defined(i386)
/* These mem* routines are builtin in GCC. */
#else	/* linux && i386 */
extern void	*memcpy(void *, const void *, size_t);
extern void	*memset(void *, int, size_t);
extern int 	memcmp(const void *, const void *, size_t);
#endif	/* linux && i386 */
extern void	*memchr(const void *, int, size_t);
extern void 	*memmove(void *, const void *, size_t);
extern void	*memccpy(void *, const void *, int, size_t);

extern size_t	strcspn(const char *, const char *);
extern size_t	strlen(const char *);
extern size_t	strspn(const char *, const char *);

extern char 	*strcpy(char *, const char *);
extern char 	*strncpy(char *, const char *, size_t);
extern char 	*strcat(char *, const char *);
extern char	*strncat(char *, const char *, size_t);
extern int	strcmp(const char *, const char *);
extern int	strcoll(const char *, const char *);
extern int	strncmp(const char *,const char *, size_t);
extern char	*strchr(const char *, int);
extern char	*strpbrk(const char *, const char *);
extern char	*strrchr(const char *, int);
extern char	*strstr(const char *, const char *);
extern char 	*strtok(char *, const char *);
extern char 	*strerror(int);
extern size_t 	strxfrm(char *, const char *, size_t);

extern int  ffs(long);
extern int  bzero(char *, int);
extern int  bcmp(const char *, const char *, int);
extern void bcopy(const char *, char *, int);
extern int  strcasecmp(const char*, const char*);
extern int  strncasecmp(const char*, const char*, int);
extern char *strdup(const char *);
extern char *index(const char*, int);
extern char *rindex(const char*, int);

#endif	/* MACH_KERNEL */

#endif	/* _PURE_MACH_STRING_H_ */
