#!/usr/local/bin/perl
#  common.pl - common routines shared by many files
#
#  Written by Curtis Olson.  Started August 22, 1994.
#
#  Copyright (C) 1994, 1995, 1996  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: common.pl,v 1.8 1996/01/21 02:18:47 curt Exp $
# (Log is kept at end of this file)


# We need a version number
$version = "Version <not_installed> (Alpha)";
($junk1, $version_num, $junk2) = split(/ +/, $version);

# Contributed by Christopher Browne, Oct. 24/94
sub pad { 
    return sprintf("%02d", @_[0]); 
}


# return the directory of a file name 
sub file_dirname {
    local($file) = @_;
    local($pos);

    $pos = rindex($file, "/");
    if ( $pos >= 0 ) {
	return substr($file, 0, ($pos + 1));
    } else {
	return "./";
    }
}


# return the base file name
sub file_basename {
    local($file) = @_;
    local($pos);

    $pos = rindex($file, "/");
    return substr($file, ($pos + 1));
}


# return the file name root (ending at last ".")
sub file_root {
    local($file) = @_;
    local($pos);

    $pos = rindex($file, ".");
    return substr($file, 0, $pos);
}


# return the file name extension (starting at first ".")
sub file_extension {
    local($file) = @_;
    local($pos);

    $pos = rindex($file, ".");
    return substr($file, ($pos + 1));
}


# return current date in a nice format
sub nice_date {
    local($date_fmt) = @_;

    local($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = 
        localtime(time);

    if ( $date_fmt == 1 ) {
        return &pad($mon+1) . "/" . &pad($mday) . "/" . &pad($year);
    } else {
        return &pad($mday) . "/" . &pad($mon+1) . "/" . &pad($year);
    }
}


# return current date in a raw format
sub raw_date {
    local($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = 
        localtime(time);
    return "19". &pad($year) . &pad($mon+1) . &pad($mday);
}


1;				# need to return a true value


# ----------------------------------------------------------------------------
# $Log: common.pl,v $
# Revision 1.8  1996/01/21  02:18:47  curt
# Modified Files:  categories.pl common.pl engine.pl export.pl file.pl import.pl
#                  log.pl memorized.pl reports.pl wrapper.pl
#   Updated copyright date.
#
# Revision 1.7  1995/08/18  11:34:06  curt
# Added support for the international date format.
#
# Revision 1.6  1995/07/08  01:49:00  curt
# Keep track of version number (ala the tk side)
#
# Revision 1.5  1995/06/04  13:23:12  curt
# file_extension() now returns everything after the *last* dot instead of
# everything after the first.
#
# Revision 1.4  1995/04/24  01:57:19  curt
# Split of menu setup functions into a separate file:  menu.tk
# Started rearranging structure to support multiple file formats.
#
# Revision 1.3  1995/02/23  05:08:43  curt
# Removed dependencies on tclX.
#
# Revision 1.2  1994/11/01  22:39:01  clolson
# Added log.pl --> implemented logging.
# Worked on install script.
#
# Revision 1.1  1994/10/31  15:18:51  curt
# These files resulted from the splitting of engine.pl
#
