#!/usr/local/bin/perl
#  export.pl - functions to implement exporting data to other formats
#
#  Written by Curtis Olson.  Started October 19, 1994.
#
#  Copyright (C) 1994, 1995, 1996  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: export.pl,v 1.6 1996/01/21 02:18:49 curt Exp $
# (Log is kept at end of this file)


# save data in the CBB format
sub save_cbb {
    # in: file base name
    # out: result

    local($file) = @_;

    if ($calced == 0) {
	&calc_trans();
    }

    open(SAVE, ">$file.new");

    if ($sorted_keys == 0) {
	&sort_keys();
    }

    foreach $key (@KEYS) {
	print (SAVE "$TRANS{$key}\n");
    }

    close(SAVE);

    unlink("$file.bak");
    rename("$file", "$file.bak");
    rename("$file.new", "$file");

    return "ok";
}


# Contributed by Christopher Browne, Oct. 18/94
# export a quicken export file (.qif)
sub export_qif {
    # in: file
    # out: result

    local($file) = @_;
    $sorted_keys = 0;
    $calced = 0;

    open(QIF, ">$file");

    print QIF "Type:Bank\n";      # This will need to change,
                       # eventually, to handle other
                       # varieties of QUICKEN accounts.
                       # Credit cards, investments, etc.
                       # Later.

    ($date, $check, $desc, $debit, $credit, $cat, $split, $com,
     $cleared) = ("", "", "", "", "", "", "", "", "");

    foreach $key (keys (%TRANS))
     {
        ($date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
               $junk) = split(/\t/, $TRANS{$key});
     
     # Handle date
     $yr = substr($date, 2, 2);
     $mo = substr($date, 4, 2);
     $dy = substr($date, 6, 2);
     printf QIF "D%d/%2d/%2d\n", $mo, $dy, $yr;
     
     # Handle amount
     $amount = $credit-$debit;
     printf QIF "T%.2lf\n", $amount;

     printf QIF "C%$cleared\n" unless ($cleared eq "");
     
     # Handle Ref. #
     print QIF "N$check\n" unless ($check eq "");
     print QIF "P$desc\n" unless ($desc eq "");
     print QIF "L$cat\n" unless (substr($cat, 0, 1) eq "\|");  # split txn
     # Handle splitting of txn
     if (substr($cat, 0, 1) eq "\|")
          {
          # Take: |Salary|2434.70|Tax-Fed|-0.34|Tax-FICA|-33.25|Tax-State|-5.78|
          @SPLIT = split(/\|/, $cat);
          print QIF "L$SPLIT[1]\n";   
	  # Pretend that the initial category is "the one"
          for ($i = 1 ; $i <= $#SPLIT ; $i += 2)
               {
               $scat = $SPLIT[$i];
               print QIF "S$scat\n";
               $amount = $SPLIT[$i+1];
               print QIF "\$$amount\n";
               }
          }
     else
          {
          }
     print QIF "M$com\n" unless ($com eq "");
     print QIF  "^\n";
     }

    close(QIF);

    return "ok";
}


1;				# need to return a true value


# ----------------------------------------------------------------------------
# $Log: export.pl,v $
# Revision 1.6  1996/01/21  02:18:49  curt
# Modified Files:  categories.pl common.pl engine.pl export.pl file.pl import.pl
#                  log.pl memorized.pl reports.pl wrapper.pl
#   Updated copyright date.
#
# Revision 1.5  1995/07/08  01:47:42  curt
# Change delimiter from ":" to "\t"
#
# Revision 1.4  1995/06/04  13:39:28  curt
# renamed export_old_cbb() to save_cbb()
#
# Revision 1.3  1995/01/08  21:18:32  curt
# Fixed bug (introduced by myself ... 4 digit years) in quicken export
# date format.
#
# Revision 1.2  1994/11/01  22:39:08  clolson
# Added log.pl --> implemented logging.
# Worked on install script.
#
# Revision 1.1  1994/10/31  15:18:52  curt
# These files resulted from the splitting of engine.pl
#
