#!/usr/local/bin/perl
#  rep-txn-list.pl - Prints a report of the transactions sorted by date
#
#  Written by Curtis Olson.  Started November 12, 1994.
#
#  Copyright (C) 1994  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: rep-txn-list.pl,v 1.6 1995/07/21 03:37:57 curt Exp $
# (Log is kept at end of this file)


# specify the installed location of the necessary pieces.
$cbb_incl_dir = ".";
unshift(@INC, $cbb_incl_dir);
$cbb_incl_dir = "..";
unshift(@INC, $cbb_incl_dir);

require "common.pl";
require "reports.pl";
require "engine.pl";


($#ARGV >= 0) || 
    die "Usage: report [ -from mm/dd/[yy]yy ] [ -to mm/dd/[yy]yy ] accounts";


# process arguments

($fromdate, $todate, @account_list) = &process_rep_args();

if ( $fromdate eq "all" ) {
    $fromdate = "";
}

if ( $todate eq "all" ) {
    $todate = "";
}

# print "'$fromdate' '$todate' '@account_list'\n";

%ALLTRANS = ();

# load all matching transactions from all specified accounts (ignoring
# those that are outside the specified date range)

foreach $account ( @account_list ) {
    $name = &file_basename($account);

    # open the account
    (&load_trans($account) eq "ok") || die "Cannot open account:  $account";

    $result = &first_trans();
    while ( $result ne "none" ) {
        ($key, $trans) = split(/\t/, $result, 2);
        ($date, $junk) = split(/\t/, $trans, 2);

        if ( (($fromdate == 0) || ($fromdate <= $date)) && 
            (($todate == 0) || ($todate >= $date)) ) {
	    $ALLTRANS{"$key$name"} = $trans;
        }

        $result = &next_trans();
    }
}

# sort and print
foreach $key (sort (keys %ALLTRANS) ) {
    # print $ALLTRANS{$key} . "\n";
    &format_line("$ALLTRANS{$key}");
}


$gtotal = 0.00;

sub format_line {
    local($date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
          $total) = split(/\t/, @_[0]);

    ($year,$mon,$day) = $date =~ /(\d\d\d\d)(\d\d)(\d\d)/;
    $year = substr($year, 2, 4);

    $nicedate = "$mon/$day/$year";
    $cutdesc = substr($desc, 0, 15);
    $cutcom = substr($com, 0, 15);
    $nicecat = substr($cat, 0, 9);
    if ( substr($cat, 0, 1) eq "|" ) {
        $nicecat = "-Splits-";
    }

    $gtotal += $credit - $debit;

    printf("%5s  %-8s  %-15s  %9.2f  %9.2f  %-1s  %9.2f\n",
          $check, $nicedate, $cutdesc, $debit, $credit, $cleared, $gtotal);
    printf("%5s  %-8s  %-15s  %-9s\n\n", "", "", $cutcom, $nicecat);
}

# ----------------------------------------------------------------------------
# $Log: rep-txn-list.pl,v $
# Revision 1.6  1995/07/21  03:37:57  curt
# Fixed a bug which caused the date range options to fail.
#
# Revision 1.5  1995/07/20  02:47:05  curt
# Changes to handle multiple accounts as input.
#
# Revision 1.4  1995/07/09  04:00:59  curt
# tweaked include path
#
# Revision 1.3  1995/07/08  01:44:45  curt
# Change delimiter from ":" to "\t"
#
# Revision 1.2  1995/07/04  22:39:47  curt
# Miscellaneous tweaking.
#
# Revision 1.1  1995/07/04  21:27:37  curt
# Added Files: rep-by-cat-shrt.pl rep-by-cat.pl rep-txn-list.pl
#   Moved these files to .../cbb/reports
#
# Revision 1.4  1994/11/28  20:07:31  clolson
# Moved "guts" to report.pl
#
# Revision 1.3  1994/11/20  15:37:27  curt
# Tiny perl4/5 compatibility changes.
#
# Revision 1.2  1994/11/14  21:25:45  clolson
# Added -from date and -to date options.
#
# Revision 1.1  1994/11/14  20:36:04  clolson
# Started working on reports !!!
#
