/* $Id: average.c,v 4.1 1995/08/10 20:37:01 lupus Exp lupus $ */

#include "xfinans.h"
#include "clist.h"
#include "gregor.h"
#include "average.h"

double averageBalance(CLIST *poster, long f_date, long l_date)
{
   int t=0;
   int antal, days, totalDays;
   long d1,d2;
   double bal=0.0, avg=0.0;

   antal=poster->size;
   totalDays=rentedage(f_date,l_date);

   if(f_date==0 || l_date==0 || l_date<f_date)
     return 0.0;

   while( t<antal && ((struct postering *)retrieve(t+1,poster))->dato<f_date ) {
     bal+=((struct postering *)retrieve(t+1,poster))->bel;
     t++;
   }

   if (t==antal) {  /* the date-interval lies after the last transaction. */
     return bal;    /* then the average balance is the balance at the     */
   }                /* time of the last transaction.                      */

   d1=f_date;
   while( t<antal && ((struct postering *)retrieve(t+1,poster))->dato<l_date ) {
      d2=((struct postering *)retrieve(t+1,poster))->dato;
      days=rentedage(d1,d2);
      avg+=bal*days/(double)totalDays;

      /* printf("  %d   %d   %3d   %9.2f   %9.2f   %9.2f\n",
		d1,d2,days,bal,bal*days/(double)totalDays,avg);  */

      d1=((struct postering *)retrieve(t+1,poster))->dato;
      bal+=((struct postering *)retrieve(t+1,poster))->bel;
      t++;
    }
   d2=l_date;
   days=rentedage(d1,d2);
   avg+=bal*days/(double)totalDays;

   /* printf("  %d   %d   %3d   %9.2f   %9.2f   %9.2f\n",
	  d1,d2,days,bal,bal*days/(double)totalDays,avg); */

   return(avg);
}



