/* $Id: config.c,v 4.3 1996/06/16 20:14:55 lupus Exp lupus $ */

#include <stdio.h>
#include "xfinans.h"
#include "config.h"
#include "country.h"
#include "programConfig.h"

#include "xfError.h"
#include "post.h"
#include "str.h"
#include "date.h"
#include "displayLimit.h"

static int date_format=yymmdd;     /* default values */
static int two_column=0;
int showCommitted=0;
static int show_all=1;
static int postscript=0;
static char printCommand[80];
static char dateFormatString[80];
int dateOrder=ddmmyy;
static int numberOfDecimals=2;
char floatFormatString[10];
char floatShortFormatString[10];
int fourDigitYearDisplay=0;
int showTransNumbers=0;
int showCatNumbers=0;
int showCatNames=0;
static int displayBeforeToday=-1; /* -1 means "ever" before */
static int displayAfterToday=-1;  /* -1 means "ever" after  */

void set_display_before(int d) {
  displayBeforeToday=d;
}

void set_display_after(int d) {
  displayAfterToday=d;
}

int get_display_before_days() {
  return displayBeforeToday;
}

int get_display_after_days() {
  return displayAfterToday;
}

Date get_display_before() {
  if(displayBeforeToday>=0)
    return prevDate(today(), P_DAY, displayBeforeToday);
  else
    return 0;
}

Date get_display_after() {
  if(displayAfterToday>=0)
    return nextDate(today(), P_DAY, displayAfterToday);
  else
    return 0;
}

void set_date_format(int df) {
  date_format=df;
}

int get_date_format(void) {
  return date_format;
}

void toggle_two_column(void) {
  two_column=!two_column;
}

int get_two_column() {
  return two_column;
}

void toggle_show_all(void) {
  show_all=!show_all;
  
  if(show_all) 
    noLimitPosts();
  else
  defaultLimitPosts();
  
  updateMarkWithText(ALL_POSTINGS, show_all);
  opdaterPostList();
}

int get_show_all(void) {
  return show_all;
}

void togglePS(void) {
  postscript = !postscript;
}

void setPS(int ps) {
  postscript = ps;
}

int getPS(void) {
  return postscript;
}

void selectPrinter(char *p) {
  zeroAddStrncpy(printCommand,p,79);
}

char *getPrintCommand(void) {
  return printCommand;
}

char *getDateFormatString(void) {
  return dateFormatString;
}

void setDateFormatString(char *s) {
  zeroAddStrncpy(dateFormatString,s,79);
}

int getDateOrder(void) {
  return dateOrder;
}

void setDateOrder(int o) {
  dateOrder=o;
}

void setFloatFormat(int format) {
  numberOfDecimals=format;
  if(numberOfDecimals<0)
    numberOfDecimals=0;
  else if(numberOfDecimals>7)
    numberOfDecimals=7;
  sprintf(floatFormatString, "%%9.%df", numberOfDecimals);
  sprintf(floatShortFormatString, "%%.%df", numberOfDecimals);
}

int getFloatFormat() {
  return numberOfDecimals;
}

void toggle_four_digit_year(void) {
  fourDigitYearDisplay=!fourDigitYearDisplay;
  updateMarkWithText(FOUR_DIGIT_YEAR, fourDigitYearDisplay);
}

void toggle_show_trans_numbers(void) {
  showTransNumbers=!showTransNumbers;
  updateMarkWithText(SHOW_TRANS_NUM, showTransNumbers);
}

void toggle_show_cat_numbers(void) {
  showCatNumbers=!showCatNumbers;
  updateMarkWithText(SHOW_CAT_NUM, showCatNumbers);
}

void toggle_show_cat_names(void) {
  showCatNames=!showCatNames;
  updateMarkWithText(SHOW_CAT_NAMES, showCatNames);
}

void save_configuration(void) {
  FILE *fp;
  
  if( (fp=fopen(CONFIG_FILE, "w"))==NULL ) {
    xfError(ERR_CANT_WRITE_FILE, NONFATAL,"can't write");
    return;
  }
  fprintf(fp, "date format\n%d\n", date_format);
  fprintf(fp, "two column\n%d\n", two_column);
  fprintf(fp, "show committed\n%d\n", showCommitted);
  fprintf(fp, "show all\n%d\n", show_all);
  fprintf(fp, "print command\n%s\n", printCommand);
  fprintf(fp, "PostScript\n%d\n", postscript);
  fprintf(fp, "Date format string\n%s\n", dateFormatString);
  fprintf(fp, "Date order\n%d\n", dateOrder);
  fprintf(fp, "Number of decimals on currency\n%d\n", numberOfDecimals);
  fprintf(fp, "Four digit year display\n%d\n", fourDigitYearDisplay);
  fprintf(fp, "Show transaction numbers\n%d\n", showTransNumbers);
  fprintf(fp, "Show category numbers\n%d\n", showCatNumbers);
  fprintf(fp, "Show category names\n%d\n", showCatNames);
  fprintf(fp, "Display limit - days before current\n%d\n", displayBeforeToday);
  fprintf(fp, "Display limit - days after  current\n%d\n", displayAfterToday);
  fclose(fp);
}

void config_default() {
  strcpy(printCommand, DEFAULT_PRINT_COMMAND);  /* default value */
  strcpy(dateFormatString, DEFAULT_DATE_FORMAT_STRING); /* default value */
  strcpy(floatFormatString, "%9.2f");           /* default value */
  strcpy(floatShortFormatString, "%.2f");       /* default value */
}

void load_configuration(void) {
  FILE *fp;
  char buf[80];
  int l;
  
  config_default();

  if( (fp=fopen(CONFIG_FILE, "r"))!=NULL ) {
    fgets(buf,80,fp);
    fgets(buf,80,fp);
    date_format=atoi(buf);

    fgets(buf,80,fp);
    fgets(buf,80,fp);
    two_column=atoi(buf);

    fgets(buf,80,fp);
    fgets(buf,80,fp);
    showCommitted=atoi(buf);

    fgets(buf,80,fp);
    fgets(buf,80,fp);
    show_all=atoi(buf);

    fgets(buf,80,fp);
    fgets(buf,80,fp);
    l=strlen(buf);
    if(l>1)
      zeroAddStrncpy(printCommand,buf,l-1);
    else
      strcpy(printCommand,DEFAULT_PRINT_COMMAND);
    
    fgets(buf,80,fp);
    fgets(buf,80,fp);
    postscript=atoi(buf);

    if(!feof(fp))
      fgets(buf,80,fp);
    if(!feof(fp)) {
      fgets(buf,80,fp);
      l=strlen(buf);
      if(l>1)
	zeroAddStrncpy(dateFormatString,buf,l-1);
      else
	strcpy(dateFormatString, DEFAULT_DATE_FORMAT_STRING);   /* default value */
    }
    
    if(!feof(fp))
      fgets(buf,80,fp); 
    if(!feof(fp)) {
      fgets(buf,80,fp);
      dateOrder=atoi(buf);
    }

    if(!feof(fp))
      fgets(buf,80,fp); 
    if(!feof(fp)) {
      fgets(buf,80,fp);
      setFloatFormat(atoi(buf));
    }

    if(!feof(fp))
      fgets(buf,80,fp); 
    if(!feof(fp)) {
      fgets(buf,80,fp);
      fourDigitYearDisplay=atoi(buf);
    }

    if(!feof(fp))
      fgets(buf,80,fp); 
    if(!feof(fp)) {
      fgets(buf,80,fp);
      showTransNumbers=atoi(buf);
    }

    if(!feof(fp))
      fgets(buf,80,fp); 
    if(!feof(fp)) {
      fgets(buf,80,fp);
      showCatNumbers=atoi(buf);
    }

    if(!feof(fp))
      fgets(buf,80,fp); 
    if(!feof(fp)) {
      fgets(buf,80,fp);
      showCatNames=atoi(buf);
    }

    if(!feof(fp))
      fgets(buf,80,fp); 
    if(!feof(fp)) {
      fgets(buf,80,fp);
      displayBeforeToday=atoi(buf);
    }

    if(!feof(fp))
      fgets(buf,80,fp); 
    if(!feof(fp)) {
      fgets(buf,80,fp);
      displayAfterToday=atoi(buf);
    }

    fclose(fp);
  } 
  date_format_change();
  
  updateMarkWithText(TWO_COLUMN_AMOUNT, two_column);
  updateMarkWithText(SHOW_COMMIT_BAL, showCommitted);

  if(show_all) 
    noLimitPosts();
  else
    defaultLimitPosts();

  updateMarkWithText(ALL_POSTINGS, show_all);
  
  winSetPrintCommand(printCommand);
  updateMarkWithText(POSTSCRIPT_LABEL, postscript);
  updateMarkWithText(ASCII_TEXT_LABEL, !postscript);

  updateMarkWithText(FOUR_DIGIT_YEAR, fourDigitYearDisplay);
  updateMarkWithText(SHOW_TRANS_NUM, showTransNumbers);
  updateMarkWithText(SHOW_CAT_NUM, showCatNumbers);
  updateMarkWithText(SHOW_CAT_NAMES, showCatNames);

  if(displayBeforeToday>=0)
    setDisplayFromLimit(get_display_before());
  if(displayAfterToday>=0)
    setDisplayToLimit(get_display_after());
}
